/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view.subfeatures;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureDescriptor;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFSimpleSubFeatureDescriptor
extends SubFeatureDescriptor {
    protected final String featureNameToEdit;

    public EMFSimpleSubFeatureDescriptor(String featureName) {
        this.featureNameToEdit = featureName;
    }

    @Override
    public List<Object> getSubElementsToEdit(List<Object> editedObjects) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object object : editedObjects) {
            if (!(object instanceof EObject)) continue;
            EStructuralFeature feature = ((EObject)object).eClass().getEStructuralFeature(this.featureNameToEdit);
            if (feature != null) {
                Object values = ((EObject)object).eGet(feature);
                if (values instanceof List) {
                    results.addAll((List)values);
                    continue;
                }
                if (values == null) continue;
                results.add(values);
                continue;
            }
            org.eclipse.papyrus.properties.runtime.Activator.log.error("Impossible to find the feature [" + this.featureNameToEdit + "] for object: " + object, null);
        }
        return results;
    }

    public String getFeatureNameToEdit() {
        return this.featureNameToEdit;
    }

    public String getText() {
        return "EMF Feature: " + this.featureNameToEdit;
    }

    public Image getImage() {
        return Activator.getImage("/icons/EMFFeatureDescriptor.gif");
    }

    @Override
    public EMFSimpleSubFeatureDescriptorState createState(boolean readOnly) {
        return new EMFSimpleSubFeatureDescriptorState(this, readOnly);
    }

    public class EMFSimpleSubFeatureDescriptorState
    extends SubFeatureDescriptor.SubFeatureDescriptorState {
        private PropertyChangeSupport changeSupport;
        private String featureNameState;

        public EMFSimpleSubFeatureDescriptorState(EMFSimpleSubFeatureDescriptor emfSimpleSubFeatureDescriptor, boolean readOnly) {
            super(emfSimpleSubFeatureDescriptor, readOnly);
            this.featureNameState = emfSimpleSubFeatureDescriptor.getFeatureNameToEdit();
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }

        public EMFSimpleSubFeatureDescriptor getDescriptor() {
            return (EMFSimpleSubFeatureDescriptor)super.getDescriptor();
        }

        public String getText() {
            return "EMF Feature: " + this.featureNameState;
        }

        public String getEditionDialogId() {
            return "EMFSimpleSubFeatureDescriptorStateDialog";
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public void setFeatureNameState(String featureNameState) {
            String oldFeatureName = this.featureNameState;
            this.featureNameState = featureNameState;
            this.changeSupport.firePropertyChange("featureNameState", oldFeatureName, this.featureNameState);
        }

        public String getFeatureNameState() {
            return this.featureNameState;
        }

        public Node generateNode(Document document) {
            Element node = document.createElement("subFeatureDescriptor");
            node.setAttribute("featureName", this.getFeatureNameState());
            return node;
        }
    }
}

