/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view.subfeatures;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureContainerDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureContainerDescriptorState;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExpandableContainerDescriptor
extends SubFeatureContainerDescriptor {
    public static final String EXPANDABLE_CONTAINER_TYPE = "expandableContainer";
    protected final String label;
    protected Section section;

    public ExpandableContainerDescriptor(String label) {
        this.label = label;
    }

    public Composite createContainer(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.section = widgetFactory.createSection(parent, 322);
        this.section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite expandableContainer = widgetFactory.createComposite((Composite)this.section);
        this.section.setText(this.label);
        widgetFactory.paintBordersFor(expandableContainer);
        this.section.setClient((Control)expandableContainer);
        return expandableContainer;
    }

    public void disposeContainer() {
        if (this.section != null && !this.section.isDisposed()) {
            this.section.dispose();
            this.section = null;
        }
    }

    public String getText() {
        return "SubFeature Expandable Container: " + this.label;
    }

    public Image getImage() {
        return Activator.getImage("/icons/SubFeatureExpandableContainer.gif");
    }

    public ExpandableContainerDescriptorState createState(boolean readOnly) {
        return new ExpandableContainerDescriptorState(this, readOnly);
    }

    public String getLabel() {
        return this.label;
    }

    public class ExpandableContainerDescriptorState
    extends SubFeatureContainerDescriptorState {
        private String label;
        private PropertyChangeSupport changeSupport;

        public ExpandableContainerDescriptorState(ExpandableContainerDescriptor descriptor, boolean readOnly) {
            super(descriptor, readOnly);
            this.label = descriptor.getLabel();
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }

        public String getEditionDialogId() {
            return "SubFeatureExpandableContainerDescriptorStateDialog";
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public String getLabel() {
            return this.label;
        }

        public String getText() {
            return "SubFeature Expandable Container: " + this.label;
        }

        public void setLabel(String label) {
            this.label = label;
            this.changeSupport.firePropertyChange("label", this.label, this.label);
        }

        protected void generateAttributes(Element node, Document document) {
            node.setAttribute("label", this.label);
            node.setAttribute("type", ExpandableContainerDescriptor.EXPANDABLE_CONTAINER_TYPE);
        }
    }
}

