/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view.subfeatures;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureContainerDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureContainerDescriptorState;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GroupContainerDescriptor
extends SubFeatureContainerDescriptor {
    public static final String GROUP_CONTAINER_TYPE = "groupContainer";
    protected final String label;
    private Group composite;

    public GroupContainerDescriptor(String label) {
        this.label = label;
    }

    public Composite createContainer(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.composite = widgetFactory.createGroup(parent, this.label);
        return this.composite;
    }

    public void disposeContainer() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.dispose();
            this.composite = null;
        }
    }

    public String getText() {
        return "SubFeature Group Container: " + this.label;
    }

    public Image getImage() {
        return Activator.getImage("/icons/SubFeatureGroupContainer.gif");
    }

    public GroupContainerDescriptorState createState(boolean readOnly) {
        return new GroupContainerDescriptorState(this, readOnly);
    }

    public String getLabel() {
        return this.label;
    }

    public class GroupContainerDescriptorState
    extends SubFeatureContainerDescriptorState {
        private String label;
        private PropertyChangeSupport changeSupport;

        public GroupContainerDescriptorState(GroupContainerDescriptor descriptor, boolean readOnly) {
            super(descriptor, readOnly);
            this.label = descriptor.getLabel();
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }

        public String getEditionDialogId() {
            return "SubFeatureGroupContainerDescriptorStateDialog";
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
            this.changeSupport.firePropertyChange("label", this.label, this.label);
        }

        public String getText() {
            return "SubFeature Group Container: " + this.label;
        }

        protected void generateAttributes(Element node, Document document) {
            node.setAttribute("label", this.label);
            node.setAttribute("type", GroupContainerDescriptor.GROUP_CONTAINER_TYPE);
        }
    }
}

