/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.log.LogHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.papyrus.properties.tabbed.customization";
    private static Activator plugin;
    public static LogHelper log;
    private CustomizationManager fCustomizationManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)plugin);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        log = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public CustomizationManager getCustomizationManager() {
        if (this.fCustomizationManager == null) {
            this.fCustomizationManager = new CustomizationManager();
            this.init(this.fCustomizationManager);
        }
        return this.fCustomizationManager;
    }

    private void init(CustomizationManager customizationManager) {
        try {
            List registryDefaultCustomizations = CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations();
            for (MetamodelView metamodelView : registryDefaultCustomizations) {
                customizationManager.registerCustomization(metamodelView);
            }
            customizationManager.loadCustomizations();
        }
        catch (Throwable e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ID, "Error initializing customizations", e));
        }
    }

    public static Image getImage(String path) {
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            registry.put(path, Activator.imageDescriptorFromPlugin((String)ID, (String)path));
            image = registry.get(path);
        }
        return image;
    }
}

