/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.ContentHolder;
import org.eclipse.swt.graphics.Image;

public class ConfigurationContentProvider
implements ITreeContentProvider,
PropertyChangeListener {
    private SectionSetDescriptorState sectionSetDescriptorState;
    private TreeViewer fViewer;

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof SectionSetDescriptorState) {
            return new Object[]{new ConstraintHolder(this.sectionSetDescriptorState), new ContentHolder(this.sectionSetDescriptorState)};
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
        if (newInput instanceof SectionSetDescriptorState) {
            if (this.sectionSetDescriptorState != null) {
                this.traverseModel((ITraversableModelElement)this.sectionSetDescriptorState, false);
            }
            this.sectionSetDescriptorState = (SectionSetDescriptorState)newInput;
            this.traverseModel((ITraversableModelElement)this.sectionSetDescriptorState, true);
        } else {
            if (this.sectionSetDescriptorState != null) {
                this.traverseModel((ITraversableModelElement)this.sectionSetDescriptorState, false);
            }
            this.sectionSetDescriptorState = null;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (this.sectionSetDescriptorState == null) {
            return new Object[0];
        }
        if (parentElement instanceof ConstraintHolder) {
            return this.sectionSetDescriptorState.getConstraintDescriptorStates().toArray();
        }
        if (parentElement instanceof ITraversableModelElement) {
            return ((ITraversableModelElement)parentElement).getChildren().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    protected void traverseModel(ITraversableModelElement objectToTraverse, boolean isHook) {
        if (objectToTraverse != null) {
            if (isHook) {
                objectToTraverse.removePropertyChangeListener((PropertyChangeListener)this);
                objectToTraverse.addPropertyChangeListener((PropertyChangeListener)this);
            } else {
                objectToTraverse.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        if (objectToTraverse.getChildren() != null && !objectToTraverse.getChildren().isEmpty()) {
            for (ITraversableModelElement child : objectToTraverse.getChildren()) {
                this.traverseModel(child, isHook);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("ADD_CHILD_EVENT".equals(evt.getPropertyName())) {
            this.fViewer.refresh(evt.getSource(), true);
            this.traverseModel((ITraversableModelElement)evt.getSource(), true);
            this.fViewer.expandToLevel(evt.getSource(), 2);
        } else if ("REMOVE_CHILD_EVENT".equals(evt.getPropertyName())) {
            this.fViewer.refresh(evt.getSource(), true);
            this.traverseModel((ITraversableModelElement)evt.getSource(), true);
            this.fViewer.expandAll();
        } else {
            this.fViewer.refresh(evt.getSource(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConstraintHolder
    extends LabelProvider
    implements ITraversableModelElement {
        private final SectionSetDescriptorState sectionSetDescriptorState;

        public ConstraintHolder(SectionSetDescriptorState sectionSetDescriptorState) {
            this.sectionSetDescriptorState = sectionSetDescriptorState;
        }

        public Image getImage(Object element) {
            return Activator.getImage("/icons/Constraints.gif");
        }

        public String getText(Object element) {
            return "Constraints";
        }

        public List<? extends ITraversableModelElement> getChildren() {
            return this.sectionSetDescriptorState.getConstraintDescriptorStates();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.sectionSetDescriptorState.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.sectionSetDescriptorState.removePropertyChangeListener(listener);
        }
    }
}

