/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.properties.runtime.state.IState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.StatesStore;
import org.eclipse.papyrus.properties.tabbed.core.view.TabDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.AbstractValidationProblem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfigurationValidator {
    protected Shell shell;
    protected ArrayList<AbstractValidationProblem> errorsFound = new ArrayList();
    protected ArrayList<AbstractValidationProblem> warningsFound = new ArrayList();
    TableViewer errorsTableViewer;
    TableViewer warningsTableViewer;

    public ConfigurationValidator(Shell shell) {
        this.shell = shell;
    }

    public boolean validateConfig(boolean forSave, boolean verbose) {
        BrokenLink brokenLink;
        Object duplicate;
        this.errorsFound.clear();
        this.warningsFound.clear();
        for (TabDescriptorState tabDescriptorState : StatesStore.getTabDescriptorStates()) {
            for (Object tabDescriptorState2 : StatesStore.getTabDescriptorStates()) {
                if (tabDescriptorState == tabDescriptorState2 || !tabDescriptorState.getId().equals(tabDescriptorState2.getId()) || this.errorsFound.contains(new Duplicate((IState)tabDescriptorState, (IState)tabDescriptorState2))) continue;
                Duplicate duplicate2 = new Duplicate((IState)tabDescriptorState, (IState)tabDescriptorState2);
                duplicate2.setMessage("Duplicated tabID: ");
                this.errorsFound.add(duplicate2);
            }
        }
        ArrayList sectionDescriptorStates = new ArrayList();
        for (SectionSetDescriptorState sectionSetDescriptorState : StatesStore.getSectionSetDescriptorStates()) {
            sectionDescriptorStates.addAll(sectionSetDescriptorState.getSectionDescriptorStates());
        }
        for (SectionDescriptorState sectionDescriptorState : sectionDescriptorStates) {
            for (SectionDescriptorState sectionDescriptorState2 : sectionDescriptorStates) {
                if (sectionDescriptorState == sectionDescriptorState2 || !sectionDescriptorState.getId().equals(sectionDescriptorState2.getId()) || this.errorsFound.contains(new Duplicate((IState)sectionDescriptorState, (IState)sectionDescriptorState2))) continue;
                duplicate = new Duplicate((IState)sectionDescriptorState, (IState)sectionDescriptorState2);
                ((AbstractValidationProblem)duplicate).setMessage("Duplicated sectionID: ");
                this.errorsFound.add((AbstractValidationProblem)duplicate);
            }
        }
        for (TabDescriptorState tabDescriptorState : StatesStore.getTabDescriptorStates()) {
            for (TabDescriptorState tabDescriptorState2 : StatesStore.getTabDescriptorStates()) {
                if (tabDescriptorState == tabDescriptorState2 || !tabDescriptorState.getLabel().equals(tabDescriptorState2.getLabel()) || this.warningsFound.contains(new Duplicate((IState)tabDescriptorState, (IState)tabDescriptorState2))) continue;
                duplicate = new Duplicate((IState)tabDescriptorState, (IState)tabDescriptorState2);
                ((AbstractValidationProblem)duplicate).setMessage("Confusing tab label: ");
                this.warningsFound.add((AbstractValidationProblem)duplicate);
            }
        }
        for (SectionDescriptorState sectionDescriptorState : sectionDescriptorStates) {
            boolean found = false;
            for (TabDescriptorState tabDescriptorState : StatesStore.getTabDescriptorStates()) {
                if (!sectionDescriptorState.getTargetTab().equals(tabDescriptorState.getId())) continue;
                found = true;
            }
            if (found) continue;
            brokenLink = new BrokenLink((IState)sectionDescriptorState);
            brokenLink.setMessage("Broken link for TargetTab in : ");
            this.errorsFound.add(brokenLink);
        }
        for (SectionDescriptorState sectionDescriptorState : sectionDescriptorStates) {
            boolean found = false;
            if (sectionDescriptorState.getAfterSection().equals("top")) continue;
            for (SectionDescriptorState sectionDescriptorState2 : sectionDescriptorStates) {
                if (!sectionDescriptorState.getAfterSection().equals(sectionDescriptorState2.getId())) continue;
                found = true;
            }
            if (found) continue;
            brokenLink = new BrokenLink((IState)sectionDescriptorState);
            brokenLink.setMessage("Broken link for AfterSection in : ");
            this.warningsFound.add(brokenLink);
        }
        ArrayList replacedSectionStates = new ArrayList();
        for (SectionDescriptorState sectionDescriptorState : sectionDescriptorStates) {
            replacedSectionStates.addAll(sectionDescriptorState.getReplacedSectionStates());
        }
        for (SectionDescriptorState.ReplacedSectionState replacedSectionState : replacedSectionStates) {
            boolean found = false;
            for (SectionDescriptorState sectionDescriptorState : sectionDescriptorStates) {
                if (!replacedSectionState.getId().equals(sectionDescriptorState.getId())) continue;
                found = true;
            }
            if (found) continue;
            BrokenLink brokenLink2 = new BrokenLink((IState)replacedSectionState);
            brokenLink2.setMessage("Broken link for Identifier in : ");
            this.warningsFound.add(brokenLink2);
        }
        if (this.errorsFound.isEmpty() && this.warningsFound.isEmpty()) {
            if (verbose) {
                MessageDialog.openInformation((Shell)this.shell, (String)"Validation report", (String)"No error and no warning found");
            }
            return true;
        }
        ReportDialog dialog = new ReportDialog(this.shell, forSave);
        dialog.open();
        return forSave && dialog.getReturnCode() == 0;
    }

    protected class BrokenLink
    extends AbstractValidationProblem {
        protected IState state;

        public IState getState() {
            return this.state;
        }

        public void setStateA(IState state) {
            this.state = state;
        }

        public BrokenLink(IState state) {
            this.setMessage("BrokenLink : ");
            this.state = state;
        }

        public String getText() {
            return String.valueOf(this.message) + this.state.getText();
        }

        public Image getImage() {
            return Activator.getImage("/icons/BrokenLink.gif");
        }
    }

    protected class Duplicate
    extends AbstractValidationProblem {
        protected IState stateA;
        protected IState stateB;

        public IState getStateA() {
            return this.stateA;
        }

        public void setStateA(IState state) {
            this.stateA = state;
        }

        public IState getStateB() {
            return this.stateB;
        }

        public void setStateB(IState state) {
            this.stateB = state;
        }

        public Duplicate(IState stateA, IState stateB) {
            this.setMessage("Duplicate : ");
            this.stateA = stateA;
            this.stateB = stateB;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Duplicate) {
                return ((Duplicate)obj).getStateA() == this.stateA || ((Duplicate)obj).getStateB() == this.stateA;
            }
            return super.equals(obj);
        }

        public String getText() {
            return String.valueOf(this.message) + this.stateA.getText() + " <-> " + this.stateB.getText();
        }

        public Image getImage() {
            return Activator.getImage("/icons/Duplicate.gif");
        }
    }

    protected class ReportDialog
    extends TitleAreaDialog {
        private boolean forSave;

        public ReportDialog(Shell parentShell, boolean forSave) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.forSave = forSave;
        }

        public Control createContents(Composite parent) {
            Control contents = super.createContents(parent);
            this.setTitle("Validation report");
            this.setMessage("Please reconsider the following issues.", 0);
            return contents;
        }

        protected Control createProblemReportArea(Composite conposite) {
            Composite contents = new Composite(conposite, 2048);
            contents.setLayout((Layout)new GridLayout(1, true));
            contents.setLayoutData((Object)new GridData(4, 4, true, true));
            LabelProvider labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    if (element instanceof AbstractValidationProblem) {
                        return ((AbstractValidationProblem)element).getImage();
                    }
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof AbstractValidationProblem) {
                        return ((AbstractValidationProblem)element).getText();
                    }
                    return element.toString();
                }
            };
            IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return ((ArrayList)inputElement).toArray();
                }
            };
            Label labelErrors = new Label(contents, 0);
            labelErrors.setText("Error(s) found: ");
            int flags = 2820;
            ConfigurationValidator.this.errorsTableViewer = new TableViewer(contents, flags);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = this.convertWidthInCharsToPixels(80);
            gridData.heightHint = this.convertHeightInCharsToPixels(18);
            ConfigurationValidator.this.errorsTableViewer.getControl().setLayoutData((Object)gridData);
            ConfigurationValidator.this.errorsTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            ConfigurationValidator.this.errorsTableViewer.setContentProvider((IContentProvider)contentProvider);
            Label labelWarnings = new Label(contents, 0);
            labelWarnings.setText("Warning(s) found: ");
            ConfigurationValidator.this.warningsTableViewer = new TableViewer(contents, flags);
            GridData gridData2 = new GridData(4, 4, true, true);
            gridData2.widthHint = this.convertWidthInCharsToPixels(80);
            gridData2.heightHint = this.convertHeightInCharsToPixels(18);
            ConfigurationValidator.this.warningsTableViewer.getControl().setLayoutData((Object)gridData2);
            ConfigurationValidator.this.warningsTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            ConfigurationValidator.this.warningsTableViewer.setContentProvider((IContentProvider)contentProvider);
            return contents;
        }

        protected Control createDialogArea(Composite parent) {
            Composite parentComposite = (Composite)super.createDialogArea(parent);
            this.initializeDialogUnits((Control)parentComposite);
            this.createProblemReportArea(parentComposite);
            ConfigurationValidator.this.errorsTableViewer.setInput(ConfigurationValidator.this.errorsFound);
            ConfigurationValidator.this.warningsTableViewer.setInput(ConfigurationValidator.this.warningsFound);
            return parentComposite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            if (this.forSave) {
                this.createButton(parent, 1, "Don't save", true);
                this.createButton(parent, 0, "Save anyway", false);
            } else {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        }
    }
}

