/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.ControllerDescriptorState;
import org.eclipse.papyrus.properties.runtime.dialogs.PropertyDialog;
import org.eclipse.papyrus.properties.runtime.state.IFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.state.IState;
import org.eclipse.papyrus.properties.runtime.view.DialogDescriptor;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.PredefinedFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewService;
import org.eclipse.papyrus.properties.runtime.view.XMLParseException;
import org.eclipse.papyrus.properties.runtime.view.constraints.AppliedStereotypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicTabDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.StatesStore;
import org.eclipse.papyrus.properties.tabbed.core.view.TabDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.Messages;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.ConfigurationContentProvider;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.ConfigurationLabelProvider;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.ConfigurationValidator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.ContentHolder;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.MetamodelContentProvider;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.MetamodelLabelProvider;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.ContainerMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.ContentHolderMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.ControllerMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.EClassifierMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.FragmentMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.PredefinedFragmentMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.ReplacedSectionMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.SectionMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.SectionSetMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.StereotypeMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.state.StatePropertyTabViewProviderParser;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.papyrus.umlutils.StereotypeUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizeContentWizardPage
extends WizardPage {
    protected Document document;
    protected static final String UML_METAMODEL = "UML";
    protected FilteredTree metamodelViewer;
    protected SectionSetDescriptorState currentSectionSetDescriptorState;
    protected EClassifier currentMetaClass;
    protected TreeViewer configurationViewer;
    protected TableViewer tabViewer;
    protected TabDescriptorState selectedTab;
    protected ScrolledComposite previewArea;
    protected TabbedPropertySheetWidgetFactory factory = new TabbedPropertySheetWidgetFactory();
    protected int currentSelectionsize = 1;
    protected Combo sizeArea;
    protected static final List<String> sizeValues = Arrays.asList("1", "-1");
    protected File file;
    protected List<EObject> metamodels = new ArrayList<EObject>();
    protected CCombo metamodelSelectionCombo;
    protected Stereotype currentStereoype;
    private List<ViewerFilter> metamodelViewerFilters;

    public CustomizeContentWizardPage() {
        super(Messages.CustomizeContentWizardPage_Title, Messages.CustomizeContentWizardPage_Message, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContentExplorer((Composite)sashForm);
        this.createConfigurationArea((Composite)sashForm);
        sashForm.setWeights(new int[]{40, 60});
        this.setControl((Control)composite);
    }

    public void setInitialContent(Document document) {
        this.document = document;
        ArrayList<ITabDescriptor> tabDescriptors = new ArrayList<ITabDescriptor>();
        StatePropertyTabViewProviderParser parser = new StatePropertyTabViewProviderParser(tabDescriptors);
        try {
            parser.parseXMLfile(document, PropertyViewService.getInstance().getAllFragmentDescriptors(), new HashMap<String, DialogDescriptor>());
            StatesStore.setSectionSetDescriptorStates(parser.getSectionSetDescriptorStates());
            StatesStore.setTabDescriptorStates(parser.getTabDescriptorStates());
            this.metamodelViewer.getViewer().setContentProvider((IContentProvider)new MetamodelContentProvider(StatesStore.getSectionSetDescriptorStates()));
            this.metamodelViewer.getViewer().setLabelProvider((IBaseLabelProvider)new MetamodelLabelProvider());
            this.metamodelViewer.getViewer().setInput((Object)UMLPackage.eINSTANCE);
            this.metamodelSelectionCombo.select(0);
            this.tabViewer.setInput((Object)StatesStore.getTabDescriptorStates());
        }
        catch (XMLParseException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public Document getFinalContent() {
        return this.createFinalDocument();
    }

    protected Document createFinalDocument() {
        Node topNode = this.retrieveTopNode(this.document);
        if (topNode == null) {
            return this.document;
        }
        this.removeAllExistingSectionSetDescriptors(topNode);
        this.removeAllExistingTabDescriptors(topNode);
        for (TabDescriptorState state : StatesStore.getTabDescriptorStates()) {
            topNode.appendChild(state.generateNode(this.document));
        }
        for (TabDescriptorState state : StatesStore.getSectionSetDescriptorStates()) {
            topNode.appendChild(state.generateNode(this.document));
        }
        return this.document;
    }

    protected Node retrieveTopNode(Document document) {
        NodeList childNodes = document.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if ("propertyTabView".equals(childNode.getNodeName())) {
                return childNode;
            }
            ++i;
        }
        Activator.log.error(Messages.CustomizeContentWizardPage_Error_NoRootNode, null);
        return null;
    }

    protected void removeAllExistingSectionSetDescriptors(Node topNode) {
        NodeList children = topNode.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if ("sectionSet".equals(child.getNodeName())) {
                topNode.removeChild(child);
                child = null;
            }
            --i;
        }
    }

    protected void removeAllExistingTabDescriptors(Node topNode) {
        NodeList children = topNode.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if ("tab".equals(child.getNodeName())) {
                topNode.removeChild(child);
                child = null;
            }
            --i;
        }
    }

    protected void createConfigurationArea(Composite composite) {
        SashForm configurationAreaSashForm = new SashForm(composite, 512);
        configurationAreaSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createConfigurationEditor((Composite)configurationAreaSashForm);
        this.createPreviewArea((Composite)configurationAreaSashForm);
        configurationAreaSashForm.setWeights(new int[]{50, 50});
    }

    protected void createConfigurationEditor(Composite composite) {
        Composite configurationAreaComposite = new Composite(composite, 0);
        configurationAreaComposite.setLayout((Layout)new GridLayout(1, false));
        Label titleLabel = new Label(configurationAreaComposite, 0);
        titleLabel.setText(Messages.CustomizeContentWizardPage_ConfigurationArea_Label);
        Tree configurationTree = new Tree(configurationAreaComposite, 2048);
        configurationTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.configurationViewer = new TreeViewer(configurationTree);
        this.configurationViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.configurationViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this.configurationViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IState) {
                    CustomizeContentWizardPage.this.openEditionDialog((IState)selectedElement);
                }
            }
        });
        this.configurationViewer.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                ITreeSelection selection = (ITreeSelection)CustomizeContentWizardPage.this.configurationViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    Activator.log.warn(Messages.CustomizeContentWizardPage_Error_NoSelectionFound);
                    return;
                }
                Object selectedObject = selection.getFirstElement();
                Menu menu = null;
                if (selectedObject instanceof SectionDescriptorState) {
                    menu = new SectionMenuCreator((SectionDescriptorState)selectedObject, CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.configurationViewer.getTree());
                } else if (selectedObject instanceof FragmentDescriptorState) {
                    menu = new FragmentMenuCreator((FragmentDescriptorState)selectedObject, CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.configurationViewer.getTree());
                } else if (selectedObject instanceof PredefinedFragmentDescriptorState) {
                    menu = new PredefinedFragmentMenuCreator((PredefinedFragmentDescriptorState)selectedObject, CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.configurationViewer.getTree());
                } else if (selectedObject instanceof ContainerDescriptorState) {
                    menu = new ContainerMenuCreator((ContainerDescriptorState)selectedObject, CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.configurationViewer.getTree());
                } else if (selectedObject instanceof ControllerDescriptorState) {
                    menu = new ControllerMenuCreator((ControllerDescriptorState)selectedObject, CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.configurationViewer.getTree());
                } else if (selectedObject instanceof ContentHolder) {
                    menu = new ContentHolderMenuCreator((ContentHolder)((Object)selectedObject), CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.configurationViewer.getTree());
                } else if (selectedObject instanceof SectionDescriptorState.ReplacedSectionState) {
                    menu = new ReplacedSectionMenuCreator((SectionDescriptorState.ReplacedSectionState)selectedObject, CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.configurationViewer.getTree());
                }
                if (menu != null) {
                    menu.setVisible(true);
                }
            }
        });
    }

    protected void openEditionDialog(IState iState) {
        DialogDescriptor descriptor = PropertyViewService.getInstance().getDialogDescriptor(iState.getEditionDialogId());
        ArrayList<IState> objectsToEdit = new ArrayList<IState>();
        objectsToEdit.add(iState);
        if (descriptor != null) {
            Shell parentShell = this.getShell();
            PropertyDialog dialog = new PropertyDialog(parentShell, descriptor, objectsToEdit, new TabbedPropertySheetWidgetFactory());
            dialog.open();
        } else {
            Activator.log.warn(String.valueOf(Messages.CustomizeContentWizardPage_Error_NoEditorForElement) + iState);
        }
    }

    protected void createPreviewArea(Composite composite) {
        Composite previewAreaComposite = new Composite(composite, 0);
        previewAreaComposite.setLayout((Layout)new GridLayout(2, false));
        Composite titleArea = new Composite(previewAreaComposite, 0);
        GridLayout layout = new GridLayout(5, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        titleArea.setLayout((Layout)layout);
        titleArea.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label titleLabel = new Label(titleArea, 0);
        titleLabel.setText(Messages.CustomizeContentWizardPage_PreviewArea_Label);
        titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite selectionSize = new Composite(titleArea, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        selectionSize.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, false, false);
        selectionSize.setLayoutData((Object)data);
        Label sizeLabel = new Label(selectionSize, 0);
        sizeLabel.setText(Messages.CustomizeContentWizardPage_PreviewArea_SelectionSizeLabel);
        this.sizeArea = new Combo(selectionSize, 2056);
        this.sizeArea.setItems(sizeValues.toArray(new String[0]));
        this.sizeArea.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = CustomizeContentWizardPage.this.sizeArea.getSelectionIndex();
                if (index >= 0) {
                    CustomizeContentWizardPage.this.setCurrentSelectionsize(Integer.parseInt(sizeValues.get(index)));
                } else {
                    Activator.log.error(Messages.CustomizeContentWizardPage_Error_OutOfBoundExceptionIndex, null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateSizeArea();
        Button button = new Button(titleArea, 0);
        button.setImage(Activator.getImage("/icons/Refresh.gif"));
        button.setToolTipText(Messages.CustomizeContentWizardPage_PreviewArea_RefreshButtonTooltip);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeContentWizardPage.this.updatePreview();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button validateButton = new Button(titleArea, 0);
        validateButton.setImage(Activator.getImage("/icons/Validate.gif"));
        validateButton.setToolTipText("Validate configuration");
        validateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationValidator validator = new ConfigurationValidator(CustomizeContentWizardPage.this.getShell());
                validator.validateConfig(false, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button saveButton = new Button(titleArea, 0);
        saveButton.setImage(Activator.getImage("/icons/Save.gif"));
        saveButton.setToolTipText(Messages.CustomizeContentWizardPage_PreviewArea_SaveButtonTooltip);
        saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeContentWizardPage.this.serializeContent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite tabArea = new Composite(previewAreaComposite, 0);
        data = new GridData(4, 4, false, true);
        data.widthHint = 150;
        data.minimumWidth = 150;
        tabArea.setLayoutData((Object)data);
        layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tabArea.setLayout((Layout)layout);
        Button addTabButton = new Button(tabArea, 0);
        addTabButton.setImage(Activator.getImage("/icons/Add_12x12.gif"));
        addTabButton.setToolTipText(Messages.CustomizeContentWizardPage_PreviewArea_AddTabButtonTooltip);
        addTabButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(CustomizeContentWizardPage.this.getShell(), "Tab label", "Please enter the tab label", "", new IInputValidator(){

                    public String isValid(String newText) {
                        return null;
                    }
                });
                dialog.open();
                if (dialog.getValue() != null) {
                    DynamicTabDescriptor tabDescriptor = new DynamicTabDescriptor("", "tab_" + dialog.getValue(), dialog.getValue());
                    StatesStore.getTabDescriptorStates().add(new TabDescriptorState((ITabDescriptor)tabDescriptor, false));
                    CustomizeContentWizardPage.this.tabViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deleteTabButton = new Button(tabArea, 0);
        deleteTabButton.setImage(Activator.getImage("/icons/Delete_12x12.gif"));
        deleteTabButton.setToolTipText(Messages.CustomizeContentWizardPage_PreviewArea_DeleteTabButtonTooltip);
        deleteTabButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = CustomizeContentWizardPage.this.tabViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    StatesStore.getTabDescriptorStates().remove((TabDescriptorState)((IStructuredSelection)selection).getFirstElement());
                    CustomizeContentWizardPage.this.tabViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button moveUpTabButton = new Button(tabArea, 0);
        moveUpTabButton.setImage(Activator.getImage("/icons/Up_12x12.gif"));
        moveUpTabButton.setToolTipText(Messages.CustomizeContentWizardPage_PreviewArea_MoveUpTabButtonTooltip);
        moveUpTabButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                ISelection selection = CustomizeContentWizardPage.this.tabViewer.getSelection();
                if (selection instanceof IStructuredSelection && (index = StatesStore.getTabDescriptorStates().indexOf(((IStructuredSelection)selection).getFirstElement())) != 0) {
                    TabDescriptorState tab = (TabDescriptorState)StatesStore.getTabDescriptorStates().remove(index);
                    StatesStore.getTabDescriptorStates().add(index - 1, tab);
                    CustomizeContentWizardPage.this.tabViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button moveDownTabButton = new Button(tabArea, 0);
        moveDownTabButton.setImage(Activator.getImage("/icons/Down_12x12.gif"));
        moveDownTabButton.setToolTipText(Messages.CustomizeContentWizardPage_PreviewArea_MoveDownTabButtonTooltip);
        moveDownTabButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                ISelection selection = CustomizeContentWizardPage.this.tabViewer.getSelection();
                if (selection instanceof IStructuredSelection && (index = StatesStore.getTabDescriptorStates().indexOf(((IStructuredSelection)selection).getFirstElement())) != StatesStore.getTabDescriptorStates().size() - 1) {
                    TabDescriptorState tab = (TabDescriptorState)StatesStore.getTabDescriptorStates().remove(index);
                    StatesStore.getTabDescriptorStates().add(index + 1, tab);
                    CustomizeContentWizardPage.this.tabViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Table table = new Table(tabArea, 2048);
        GridData data2 = new GridData(4, 4, false, true);
        data2.widthHint = 150;
        data2.minimumWidth = 150;
        data2.horizontalSpan = 4;
        table.setLayoutData((Object)data2);
        this.tabViewer = new TableViewer(table);
        this.tabViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TabDescriptorState) {
                    return ((TabDescriptorState)element).getText();
                }
                return super.getText(element);
            }
        });
        this.tabViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<TabDescriptorState> results = new ArrayList<TabDescriptorState>();
                if (inputElement instanceof List) {
                    List elements = (List)inputElement;
                    for (Object o : elements) {
                        if (!(o instanceof TabDescriptorState)) continue;
                        results.add((TabDescriptorState)o);
                    }
                    return results.toArray();
                }
                return new Object[0];
            }
        });
        this.tabViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizeContentWizardPage.this.selectedTab = (TabDescriptorState)((IStructuredSelection)event.getSelection()).getFirstElement();
                CustomizeContentWizardPage.this.updatePreview();
            }
        });
        this.tabViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IState) {
                    CustomizeContentWizardPage.this.openEditionDialog((IState)selectedElement);
                }
                CustomizeContentWizardPage.this.tabViewer.refresh();
            }
        });
        this.previewArea = this.factory.createScrolledComposite(previewAreaComposite, 2048);
        this.previewArea.setAlwaysShowScrollBars(false);
        this.previewArea.setLayout((Layout)new GridLayout(1, true));
        this.previewArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite content = this.factory.createComposite((Composite)this.previewArea);
        content.setLayout((Layout)new GridLayout(1, true));
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.previewArea.setContent((Control)content);
        this.previewArea.setExpandVertical(true);
        this.previewArea.setExpandHorizontal(true);
    }

    protected void updateSizeArea() {
        if (this.sizeArea != null && !this.sizeArea.isDisposed()) {
            this.sizeArea.select(sizeValues.indexOf("" + this.currentSelectionsize));
        }
        this.updatePreview();
    }

    protected boolean isSectionSetDescriptorStateValid(SectionSetDescriptorState state) {
        if (state.getSelectionSize() > this.getCurrentSelectionsize()) {
            return false;
        }
        List constraintDescriptorStates = state.getConstraintDescriptorStates();
        for (ConstraintDescriptorState constraintDescriptorState : constraintDescriptorStates) {
            if (this.getCurrentMetaClass() != null) {
                Class elementClass;
                if (!(constraintDescriptorState instanceof ObjectTypeConstraintDescriptor.ObjectTypeConstraintDescriptorState) || !(elementClass = ((ObjectTypeConstraintDescriptor.ObjectTypeConstraintDescriptorState)constraintDescriptorState).getElementClassState()).isAssignableFrom(this.getCurrentMetaClass().getInstanceClass())) continue;
                return true;
            }
            if (this.getCurrentStereoype() != null) {
                List stereotypesToApply;
                if (!(constraintDescriptorState instanceof AppliedStereotypeConstraintDescriptor.AppliedStereotypeConstraintDescriptorState) || (stereotypesToApply = ((AppliedStereotypeConstraintDescriptor.AppliedStereotypeConstraintDescriptorState)constraintDescriptorState).getStereotypesToApply()).size() <= 0) continue;
                String stereotypeName = (String)stereotypesToApply.get(0);
                if (stereotypeName.equals(this.getCurrentStereoype().getQualifiedName())) {
                    return true;
                }
                List generalStereotypes = StereotypeUtil.getAllSuperStereotypes((Stereotype)this.getCurrentStereoype());
                for (Stereotype stereotype : generalStereotypes) {
                    if (!stereotypeName.equals(stereotype.getQualifiedName())) continue;
                    return true;
                }
                continue;
            }
            Activator.log.warn(Messages.CustomizeContentWizardPage_Warning_NoStereotypeNeitherMetaclass);
        }
        return false;
    }

    protected void updatePreview() {
        if (!(this.selectedTab == null || this.getCurrentMetaClass() == null && this.getCurrentStereoype() == null || this.previewArea == null || this.previewArea.isDisposed())) {
            ArrayList<SectionDescriptorState> displayedSections = new ArrayList<SectionDescriptorState>();
            String selectedTabName = this.selectedTab.getId();
            Composite parent = this.previewArea.getParent();
            this.previewArea.dispose();
            this.previewArea = null;
            this.previewArea = this.factory.createScrolledComposite(parent, 2816);
            this.previewArea.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite content = this.factory.createComposite((Composite)this.previewArea);
            content.setLayout((Layout)new GridLayout(1, true));
            this.previewArea.setExpandVertical(true);
            this.previewArea.setExpandHorizontal(true);
            this.previewArea.getHorizontalBar().setIncrement(20);
            this.previewArea.getVerticalBar().setIncrement(20);
            for (SectionSetDescriptorState sectionSetDescriptorState : StatesStore.getSectionSetDescriptorStates()) {
                if (!this.isSectionSetDescriptorStateValid(sectionSetDescriptorState)) continue;
                for (SectionDescriptorState state : sectionSetDescriptorState.getSectionDescriptorStates()) {
                    if (!selectedTabName.equals(state.getTargetTab())) continue;
                    displayedSections.add(state);
                }
            }
            ArrayList<SectionDescriptorState> filteredSectionstates = new ArrayList<SectionDescriptorState>();
            for (SectionDescriptorState sectionDescriptorState : displayedSections) {
                boolean isRemoved = false;
                String currentId = sectionDescriptorState.getId();
                for (SectionDescriptorState state : displayedSections) {
                    for (SectionDescriptorState.ReplacedSectionState replacedSectionState : state.getReplacedSectionStates()) {
                        if (!replacedSectionState.getId().equals(currentId)) continue;
                        isRemoved = true;
                    }
                }
                if (isRemoved) continue;
                filteredSectionstates.add(sectionDescriptorState);
            }
            for (SectionDescriptorState state : filteredSectionstates) {
                for (IFragmentDescriptorState fragmentDescriptorState : state.getFragmentDescriptorStates()) {
                    for (ContainerDescriptorState containerDescriptorState : fragmentDescriptorState.getContainerDescriptorStates()) {
                        containerDescriptorState.createPreview(content);
                    }
                }
            }
            this.previewArea.setContent((Control)content);
            this.previewArea.getParent().layout(true);
        }
    }

    protected void createContentExplorer(Composite composite) {
        Composite mainContentAreaComposite = new Composite(composite, 0);
        mainContentAreaComposite.setLayout((Layout)new GridLayout(1, false));
        Label contentLabel = new Label(mainContentAreaComposite, 0);
        contentLabel.setText(Messages.CustomizeContentWizardPage_ContentArea_Label);
        this.metamodelSelectionCombo = new CCombo(mainContentAreaComposite, 2056);
        this.metamodelSelectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.metamodels = this.retrieveAvailableMetamodels();
        String[] metamodelNames = this.retrieveMetamodelNames();
        this.metamodelSelectionCombo.setItems(metamodelNames);
        this.metamodelSelectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeContentWizardPage.this.metamodelViewer.getViewer().setInput((Object)CustomizeContentWizardPage.this.metamodels.get(CustomizeContentWizardPage.this.metamodelSelectionCombo.getSelectionIndex()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        int flags = 2052;
        TreeSelectionPatternFilter patternfilter = new TreeSelectionPatternFilter();
        patternfilter.setIncludeLeadingWildcard(true);
        this.metamodelViewer = new FilteredTree(mainContentAreaComposite, flags, (PatternFilter)patternfilter, true);
        this.metamodelViewer.getViewer().getControl().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                ITreeSelection selection = (ITreeSelection)CustomizeContentWizardPage.this.metamodelViewer.getViewer().getSelection();
                if (selection == null || selection.size() < 1) {
                    Activator.log.warn(Messages.CustomizeContentWizardPage_Error_NoSelectionForMenuCreation);
                    return;
                }
                Object selectedObject = selection.getFirstElement();
                Menu menu = null;
                if (selectedObject instanceof SectionSetDescriptorState) {
                    menu = new SectionSetMenuCreator(StatesStore.getSectionSetDescriptorStates(), CustomizeContentWizardPage.this.metamodelViewer.getViewer(), (SectionSetDescriptorState)selectedObject, CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.metamodelViewer.getViewer().getTree());
                } else if (selectedObject instanceof ModelElementItem) {
                    ModelElementItem item = (ModelElementItem)selectedObject;
                    EObject selectedEObject = item.getEObject();
                    if (selectedEObject instanceof EClassifier) {
                        menu = new EClassifierMenuCreator((ModelElementItem)selectedObject, StatesStore.getSectionSetDescriptorStates(), CustomizeContentWizardPage.this.metamodelViewer.getViewer(), CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.metamodelViewer.getViewer().getTree());
                    } else if (selectedEObject instanceof Stereotype) {
                        menu = new StereotypeMenuCreator((ModelElementItem)selectedObject, StatesStore.getSectionSetDescriptorStates(), CustomizeContentWizardPage.this.metamodelViewer.getViewer(), CustomizeContentWizardPage.this.getCurrentSectionSetDescriptorState(), CustomizeContentWizardPage.this.getCurrentMetaClass(), CustomizeContentWizardPage.this.getCurrentStereoype()).getMenu((Control)CustomizeContentWizardPage.this.metamodelViewer.getViewer().getTree());
                    }
                }
                if (menu != null) {
                    menu.setVisible(true);
                }
            }
        });
        this.metamodelViewer.getViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof ModelElementItem) {
                    CustomizeContentWizardPage.this.setCurrentSectionSetDescriptorState(null);
                    EObject selectedEObject = ((ModelElementItem)selectedElement).getEObject();
                    if (selectedEObject instanceof EClassifier) {
                        CustomizeContentWizardPage.this.setCurrentMetaClass((EClassifier)selectedEObject);
                        CustomizeContentWizardPage.this.setCurrentStereotype(null);
                    } else if (selectedEObject instanceof Stereotype) {
                        CustomizeContentWizardPage.this.setCurrentMetaClass(null);
                        CustomizeContentWizardPage.this.setCurrentStereotype((Stereotype)selectedEObject);
                    } else {
                        Activator.log.error(String.valueOf(Messages.CustomizeContentWizardPage_Error_SelectionStereotypeOrClassifier) + selectedEObject, null);
                    }
                } else if (selectedElement instanceof SectionSetDescriptorState) {
                    TreePath treePath;
                    Object firstSegment;
                    TreePath[] paths = selection.getPathsFor(selectedElement);
                    if (paths.length > 0 && (firstSegment = (treePath = paths[0]).getSegment(0)) instanceof ModelElementItem) {
                        EObject selectedEObject = ((ModelElementItem)firstSegment).getEObject();
                        if (selectedEObject instanceof EClassifier) {
                            CustomizeContentWizardPage.this.setCurrentMetaClass((EClassifier)selectedEObject);
                            CustomizeContentWizardPage.this.setCurrentStereotype(null);
                        } else if (selectedEObject instanceof Stereotype) {
                            CustomizeContentWizardPage.this.setCurrentMetaClass(null);
                            CustomizeContentWizardPage.this.setCurrentStereotype((Stereotype)selectedEObject);
                        } else {
                            Activator.log.error(String.valueOf(Messages.CustomizeContentWizardPage_Error_SelectionStereotypeOrClassifier) + selectedEObject, null);
                        }
                    }
                    CustomizeContentWizardPage.this.currentSectionSetDescriptorState = (SectionSetDescriptorState)selectedElement;
                }
                CustomizeContentWizardPage.this.updatePreview();
                CustomizeContentWizardPage.this.updateConfigurationArea();
            }
        });
        this.metamodelViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IState) {
                    CustomizeContentWizardPage.this.openEditionDialog((IState)selectedElement);
                }
            }
        });
    }

    protected String[] retrieveMetamodelNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (EObject object : this.metamodels) {
            if (object instanceof EPackage) {
                names.add(((EPackage)object).getName());
                continue;
            }
            if (object instanceof Profile) {
                names.add(((Profile)object).getName());
                continue;
            }
            names.add(object.toString());
        }
        return names.toArray(new String[0]);
    }

    protected void updateConfigurationArea() {
        this.configurationViewer.setInput((Object)this.currentSectionSetDescriptorState);
        this.configurationViewer.expandAll();
    }

    protected List<EObject> retrieveAvailableMetamodels() {
        ArrayList<EObject> metamodels = new ArrayList<EObject>();
        DiagramEditor editor = null;
        IEditorPart mainEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (mainEditor instanceof CoreMultiDiagramEditor) {
            editor = (DiagramEditor)((CoreMultiDiagramEditor)mainEditor).getActiveEditor();
        }
        if (editor == null) {
            Activator.log.warn(Messages.CustomizeContentWizardPage_Error_NoActiveDiagram);
            return Collections.emptyList();
        }
        EObject eObject = editor.getDiagram().getElement();
        if (eObject == null) {
            Activator.log.warn(Messages.CustomizeContentWizardPage_Error_NoActiveDiagram);
            return Collections.emptyList();
        }
        if (eObject instanceof Element) {
            metamodels.add((EObject)UMLPackage.eINSTANCE);
            Package rootPackage = PackageUtil.getRootPackage((Element)((Element)eObject));
            EList profilesApplied = rootPackage.getAllAppliedProfiles();
            for (Profile profile : profilesApplied) {
                metamodels.add((EObject)profile);
            }
        }
        return metamodels;
    }

    protected String getProfileDisplayName(Profile profile) {
        return profile.getQualifiedName();
    }

    public SectionSetDescriptorState getCurrentSectionSetDescriptorState() {
        return this.currentSectionSetDescriptorState;
    }

    public void setCurrentSectionSetDescriptorState(SectionSetDescriptorState currentSectionSetDescriptorState) {
        this.currentSectionSetDescriptorState = currentSectionSetDescriptorState;
    }

    public EClassifier getCurrentMetaClass() {
        return this.currentMetaClass;
    }

    public void setCurrentMetaClass(EClassifier currentMetaClass) {
        this.currentMetaClass = currentMetaClass;
    }

    public void setCurrentStereotype(Stereotype currentStereoype) {
        this.currentStereoype = currentStereoype;
    }

    public Stereotype getCurrentStereoype() {
        return this.currentStereoype;
    }

    protected void setCurrentSelectionsize(int currentSelectionsize) {
        this.currentSelectionsize = currentSelectionsize;
        if (this.sizeArea != null && !this.sizeArea.isDisposed()) {
            this.sizeArea.select(sizeValues.indexOf(currentSelectionsize));
        }
        this.updateSizeArea();
    }

    public int getCurrentSelectionsize() {
        return this.currentSelectionsize;
    }

    public void setNewFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public boolean serializeContent() {
        ConfigurationValidator configurationValidator = new ConfigurationValidator(this.getShell());
        if (configurationValidator.validateConfig(true, false)) {
            Job job = new Job(Messages.CustomizeContentWizardPage_Job_SavingConfiguration){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Document document = CustomizeContentWizardPage.this.getFinalContent();
                        File file = CustomizeContentWizardPage.this.getFile();
                        file.delete();
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        TransformerFactory factory = TransformerFactory.newInstance();
                        Transformer transformer = factory.newTransformer();
                        DOMSource source = new DOMSource(document);
                        StreamResult result = new StreamResult(file);
                        transformer.transform(source, result);
                        return Status.OK_STATUS;
                    }
                    catch (TransformerException e) {
                        Activator.log.error((Throwable)e);
                        return new Status(4, "org.eclipse.papyrus.properties.tabbed.customization", e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                        return new Status(4, "org.eclipse.papyrus.properties.tabbed.customization", e.getLocalizedMessage());
                    }
                }
            };
            job.schedule();
            return true;
        }
        return false;
    }

    private class TreeSelectionPatternFilter
    extends PatternFilter {
        private TreeSelectionPatternFilter() {
        }

        protected boolean isParentMatch(Viewer viewer, Object element) {
            if (element instanceof DynamicSectionDescriptor) {
                String labelText = ((DynamicSectionDescriptor)element).getId();
                if (labelText != null) {
                    return this.wordMatches(labelText);
                }
            } else {
                EObject eObject;
                String labelText;
                if (element instanceof SectionSetDescriptorState) {
                    return true;
                }
                if (element instanceof NamedElement) {
                    String labelText2 = ((NamedElement)element).getQualifiedName();
                    if (labelText2 != null) {
                        return this.wordMatches(labelText2);
                    }
                } else if (element instanceof ModelElementItem && (labelText = (eObject = ((ModelElementItem)element).getEObject()) instanceof ENamedElement ? ((ENamedElement)((ModelElementItem)element).getEObject()).getName() : ((ModelElementItem)element).getText()) != null) {
                    return this.wordMatches(labelText);
                }
            }
            return false;
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            return this.isParentMatch(viewer, element);
        }
    }
}

