/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelContentProvider;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.core.utils.FilteredCollectionView;
import org.eclipse.papyrus.core.utils.IFilter;
import org.eclipse.papyrus.properties.runtime.view.constraints.AppliedStereotypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.umlutils.StereotypeUtil;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelContentProvider
extends CustomizableModelContentProvider
implements PropertyChangeListener {
    protected final List<SectionSetDescriptorState> availableSectionSets;
    private TreeViewer fViewer;

    public MetamodelContentProvider(List<SectionSetDescriptorState> availableSectionSets) {
        super(Activator.getDefault().getCustomizationManager());
        this.availableSectionSets = availableSectionSets;
        for (SectionSetDescriptorState state : availableSectionSets) {
            state.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
    }

    public EObject[] getRootElements(Object inputElement) {
        if (inputElement instanceof EPackage) {
            return (EObject[])((EPackage)inputElement).getEClassifiers().toArray((Object[])new EClassifier[0]);
        }
        if (inputElement instanceof Profile) {
            return (EObject[])((Profile)inputElement).getOwnedStereotypes().toArray((Object[])new EObject[0]);
        }
        if (inputElement instanceof EObject) {
            return (EObject[])((EObject)inputElement).eContents().toArray((Object[])new EObject[0]);
        }
        if (inputElement instanceof List) {
            ArrayList objects = new ArrayList();
            objects.addAll((List)inputElement);
            Collections.sort(objects, new Comparator<EClassifier>(){

                @Override
                public int compare(EClassifier o1, EClassifier o2) {
                    if (o1.getName() == null) {
                        return 0;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return objects.toArray(new EObject[0]);
        }
        return new EObject[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ModelElementItem) {
            if (((ModelElementItem)parentElement).getEObject() instanceof EClassifier) {
                EClassifier parentClassifier = (EClassifier)((ModelElementItem)parentElement).getEObject();
                String qualifiedInstanceClassName = parentClassifier.getInstanceClassName();
                try {
                    final Class<?> metamodelClass = Class.forName(qualifiedInstanceClassName);
                    FilteredCollectionView filteredList = new FilteredCollectionView(this.availableSectionSets, new IFilter(){

                        public boolean isAllowed(Object object) {
                            if (object instanceof SectionSetDescriptorState) {
                                List constraintDescriptors = ((SectionSetDescriptorState)object).getDescriptor().getConstraintDescriptors();
                                for (IConstraintDescriptor constraintDescriptor : constraintDescriptors) {
                                    Class elementClass;
                                    if (!(constraintDescriptor instanceof ObjectTypeConstraintDescriptor) || !(elementClass = ((ObjectTypeConstraintDescriptor)constraintDescriptor).getElementClass()).isAssignableFrom(metamodelClass)) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                    return filteredList.toArray();
                }
                catch (ClassNotFoundException e) {
                    return new Object[0];
                }
            }
            if (((ModelElementItem)parentElement).getEObject() instanceof Stereotype) {
                final Stereotype parentStereotype = (Stereotype)((ModelElementItem)parentElement).getEObject();
                FilteredCollectionView filteredList = new FilteredCollectionView(this.availableSectionSets, new IFilter(){

                    public boolean isAllowed(Object object) {
                        if (object instanceof SectionSetDescriptorState) {
                            List constraintDescriptors = ((SectionSetDescriptorState)object).getDescriptor().getConstraintDescriptors();
                            for (IConstraintDescriptor constraintDescriptor : constraintDescriptors) {
                                List stereotypeNames;
                                if (!(constraintDescriptor instanceof AppliedStereotypeConstraintDescriptor) || (stereotypeNames = ((AppliedStereotypeConstraintDescriptor)constraintDescriptor).getStereotypeQualifiedNames()).size() <= 0) continue;
                                String stereotypeName = (String)stereotypeNames.get(0);
                                if (stereotypeName.equals(parentStereotype.getQualifiedName())) {
                                    return true;
                                }
                                List generalStereotypes = StereotypeUtil.getAllSuperStereotypes((Stereotype)parentStereotype);
                                for (Stereotype stereotype : generalStereotypes) {
                                    if (!stereotypeName.equals(stereotype.getQualifiedName())) continue;
                                    return true;
                                }
                            }
                        }
                        return false;
                    }
                });
                return filteredList.toArray();
            }
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SectionSetDescriptorState) {
            this.fViewer.refresh(true);
        }
    }

    public void dispose() {
        for (SectionSetDescriptorState state : this.availableSectionSets) {
            state.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.dispose();
    }
}

