/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewService;
import org.eclipse.papyrus.properties.tabbed.core.view.XMLPropertyTabViewProvider;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.Messages;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.CustomizeContentWizardPage;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.CustomizePropertyViewWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SelectConfigurationFileWizardPage
extends WizardPage {
    protected SelectionListener selectionListener = new RadioSelectionListener();
    protected Map<Button, IConfigurationArea> radioButtonsMapping = new HashMap<Button, IConfigurationArea>();
    protected ViewerFilter fileViewerFilter = new XMLFileViewerFilter();
    protected CreateFromScratchArea createFromScratchArea = new CreateFromScratchArea();
    protected CreateFromExistingConfigurationArea createFromExistingConfigurationArea = new CreateFromExistingConfigurationArea();
    protected ModifyExistingConfigurationArea modifyExistingConfigurationArea = new ModifyExistingConfigurationArea();
    protected ModifyPluginConfigurationArea modifyPluginConfigurationArea = new ModifyPluginConfigurationArea();
    protected File file;
    protected static final String EMPTY_STRING = "";
    protected IWizardPage nextPage;

    protected SelectConfigurationFileWizardPage() {
        super(Messages.SelectConfigurationFileWizardPage_PageName, Messages.SelectConfigurationFileWizardPage_Title, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(4, 128, true, true);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.createContentArea(composite);
    }

    protected void createContentArea(Composite composite) {
        Group userGroup = new Group(composite, 0);
        userGroup.setText(Messages.SelectConfigurationFileWizardPage_UserGroup_Label);
        userGroup.setLayout((Layout)new GridLayout(1, false));
        userGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.modifyPluginConfigurationArea = new ModifyPluginConfigurationArea();
        this.modifyPluginConfigurationArea.createContent((Composite)userGroup);
        Group devGroup = new Group(composite, 0);
        devGroup.setText(Messages.SelectConfigurationFileWizardPage_SourceGroup_Label);
        GridLayout layout = new GridLayout(1, false);
        devGroup.setLayout((Layout)layout);
        GridData groupData = new GridData(4, 4, true, false, 2, 1);
        devGroup.setLayoutData((Object)groupData);
        this.createFromScratchArea = new CreateFromScratchArea();
        this.createFromScratchArea.createContent((Composite)devGroup);
        this.createFromExistingConfigurationArea = new CreateFromExistingConfigurationArea();
        this.createFromExistingConfigurationArea.createContent((Composite)devGroup);
        this.modifyExistingConfigurationArea = new ModifyExistingConfigurationArea();
        this.modifyExistingConfigurationArea.createContent((Composite)devGroup);
        this.enableConfigurationArea(this.modifyPluginConfigurationArea);
    }

    protected void notifyButtonChanged(SelectionEvent e) {
        if (e.widget != null) {
            IConfigurationArea enabledConfigurationArea = this.radioButtonsMapping.get(e.widget);
            if (enabledConfigurationArea != null) {
                this.enableConfigurationArea(enabledConfigurationArea);
            } else {
                Activator.log.warn(String.valueOf(Messages.SelectConfigurationFileWizardPage_Error_NoAreaForWidget) + e);
            }
        }
    }

    protected void enableConfigurationArea(IConfigurationArea areaToEnable) {
        for (IConfigurationArea area : this.radioButtonsMapping.values()) {
            area.setEnable(false);
        }
        areaToEnable.setEnable(true);
        areaToEnable.validatePage();
    }

    protected IConfigurationArea getEnableConfigurationArea() {
        for (Button button : this.radioButtonsMapping.keySet()) {
            if (!button.getSelection()) continue;
            return this.radioButtonsMapping.get(button);
        }
        return null;
    }

    protected boolean isValid(Control control) {
        return control != null && !control.isDisposed();
    }

    public IWizardPage getNextPage() {
        if (this.getWizard() instanceof CustomizePropertyViewWizard) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    CustomizeContentWizardPage newPage = ((CustomizePropertyViewWizard)SelectConfigurationFileWizardPage.this.getWizard()).customizeContentPage;
                    Document initialDocument = SelectConfigurationFileWizardPage.this.getEnableConfigurationArea().generateInitialContent();
                    newPage.setInitialContent(initialDocument);
                    SelectConfigurationFileWizardPage.this.file = SelectConfigurationFileWizardPage.this.getEnableConfigurationArea().getNewFile();
                    newPage.setNewFile(SelectConfigurationFileWizardPage.this.file);
                    SelectConfigurationFileWizardPage.this.setNextPage((IWizardPage)newPage);
                }
            });
            return this.nextPage;
        }
        return null;
    }

    protected void setNextPage(IWizardPage page) {
        this.nextPage = page;
    }

    public File getNewFile() {
        return this.file;
    }

    public void performPostSerializationAction() {
        this.getEnableConfigurationArea().performPostSerializationAction();
    }

    protected abstract class AbstractNameConfigurationArea
    implements INameConfigurationArea {
        protected Text nameText;

        protected AbstractNameConfigurationArea() {
        }

        public String getNewName() {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.nameText)) {
                return this.nameText.getText();
            }
            String generatedName = Messages.bind((String)Messages.SelectConfigurationFileWizardPage_DefaultConfigurationName, (Object)System.currentTimeMillis());
            Activator.log.warn(Messages.bind((String)Messages.SelectConfigurationFileWizardPage_ErrorMessage_NoValidTextArea, (Object)generatedName));
            return generatedName;
        }

        public void validatePage() {
            if (this.nameText.getText() == null || this.nameText.getText().equals(SelectConfigurationFileWizardPage.EMPTY_STRING)) {
                SelectConfigurationFileWizardPage.this.setPageComplete(false);
                SelectConfigurationFileWizardPage.this.setMessage(Messages.SelectConfigurationFileWizardPage_ErrorMessage_notValidName, 3);
            } else {
                SelectConfigurationFileWizardPage.this.setPageComplete(true);
                SelectConfigurationFileWizardPage.this.setMessage(SelectConfigurationFileWizardPage.EMPTY_STRING, 0);
            }
        }
    }

    protected class CreateFromExistingConfigurationArea
    extends AbstractNameConfigurationArea {
        protected Button createFromExistingConfigurationButton;
        protected Button createFromExistingConfigurationSelectionButton;
        protected Text createFromExistingConfigurationText;
        protected Text folderText;
        protected Button folderButton;

        protected CreateFromExistingConfigurationArea() {
        }

        public Composite createContent(Composite parent) {
            Composite mainComposite = new Composite(parent, 2048);
            mainComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            mainComposite.setLayout((Layout)new GridLayout(4, false));
            this.createFromExistingConfigurationButton = new Button(mainComposite, 16);
            this.createFromExistingConfigurationButton.addSelectionListener(SelectConfigurationFileWizardPage.this.selectionListener);
            SelectConfigurationFileWizardPage.this.radioButtonsMapping.put(this.createFromExistingConfigurationButton, this);
            Label createFromExistingConfigurationLabel = new Label(mainComposite, 0);
            createFromExistingConfigurationLabel.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            createFromExistingConfigurationLabel.setText(Messages.SelectConfigurationFileWizardPage_CreateFromExistingConfiguration_Label);
            Label createFromExistingConfigurationExistingLabel = new Label(mainComposite, 0);
            createFromExistingConfigurationExistingLabel.setText(Messages.SelectConfigurationFileWizardPage_CreateFromExistingConfigFile_Label);
            createFromExistingConfigurationExistingLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            this.createFromExistingConfigurationText = new Text(mainComposite, 2056);
            this.createFromExistingConfigurationText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.createFromExistingConfigurationSelectionButton = new Button(mainComposite, 0);
            this.createFromExistingConfigurationSelectionButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IFile[] selectedFiles = WorkspaceResourceDialog.openFileSelection((Shell)SelectConfigurationFileWizardPage.this.getShell(), (String)Messages.SelectConfigurationFileWizardPage_CreateFromExistingConfigFile_Dialog_Title, (String)Messages.SelectConfigurationFileWizardPage_CreateFromExistingConfigFile_Dialog_Message, (boolean)false, (Object[])new Object[0], Collections.singletonList(((CreateFromExistingConfigurationArea)CreateFromExistingConfigurationArea.this).SelectConfigurationFileWizardPage.this.fileViewerFilter));
                    if (selectedFiles != null && selectedFiles.length == 1) {
                        IFile selectedFile = selectedFiles[0];
                        CreateFromExistingConfigurationArea.this.createFromExistingConfigurationText.setText(selectedFile.getFullPath().toString());
                        CreateFromExistingConfigurationArea.this.validatePage();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.createFromExistingConfigurationSelectionButton.setText(Messages.SelectConfigurationFileWizardPage_CreateFromExistingConfigurationSelectionButton_Label);
            Label nameLabel = new Label(mainComposite, 0);
            nameLabel.setText(Messages.SelectConfigurationFileWizardPage_CreateFromExistingConfigName_Label);
            nameLabel.setToolTipText(Messages.SelectConfigurationFileWizardPage_CreateFromExistingConfigName_Tooltip);
            GridData labelData = new GridData(4, 0x1000000, false, false, 2, 1);
            nameLabel.setLayoutData((Object)labelData);
            this.nameText = new Text(mainComposite, 2048);
            this.nameText.setText(Messages.SelectConfigurationFileWizardPage_CreateFromExistingConfigName_DefaultValue);
            GridData textData = new GridData(4, 4, true, false, 2, 1);
            this.nameText.setLayoutData((Object)textData);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateFromExistingConfigurationArea.this.validatePage();
                }
            });
            Label folderLabel = new Label(mainComposite, 0);
            folderLabel.setText("Folder:");
            folderLabel.setToolTipText("Select the folder where you want to create the new file");
            labelData = new GridData(4, 0x1000000, false, false, 2, 1);
            folderLabel.setLayoutData((Object)labelData);
            this.folderText = new Text(mainComposite, 2048);
            this.folderText.setText(SelectConfigurationFileWizardPage.EMPTY_STRING);
            this.folderText.setEditable(false);
            textData = new GridData(4, 4, true, false, 1, 1);
            this.folderText.setLayoutData((Object)textData);
            this.folderButton = new Button(mainComposite, 0);
            this.folderButton.setText("Select...");
            this.folderButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ContainerSelectionDialog selectionDialog = new ContainerSelectionDialog(SelectConfigurationFileWizardPage.this.getShell(), null, true, "Select the container where the file will be created");
                    if (selectionDialog.open() == 0) {
                        Object[] result = selectionDialog.getResult();
                        if (result.length < 1) {
                            Activator.log.error("no container was selected in the dialog", null);
                            return;
                        }
                        Object container = result[0];
                        if (container instanceof Path) {
                            Path path = (Path)container;
                            CreateFromExistingConfigurationArea.this.folderText.setText(path.toString());
                        }
                        CreateFromExistingConfigurationArea.this.validatePage();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return mainComposite;
        }

        public void setEnable(boolean enable) {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.createFromExistingConfigurationButton)) {
                this.createFromExistingConfigurationButton.setSelection(enable);
                this.createFromExistingConfigurationSelectionButton.setEnabled(enable);
                this.createFromExistingConfigurationText.setEnabled(enable);
                this.folderButton.setEnabled(enable);
                this.nameText.setEnabled(enable);
                if (enable) {
                    this.nameText.setFocus();
                    this.nameText.selectAll();
                }
            }
        }

        public void validatePage() {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.nameText)) {
                if (this.createFromExistingConfigurationText.getText() == null || this.createFromExistingConfigurationText.getText().equals(SelectConfigurationFileWizardPage.EMPTY_STRING)) {
                    SelectConfigurationFileWizardPage.this.setPageComplete(false);
                    SelectConfigurationFileWizardPage.this.setMessage(Messages.SelectConfigurationFileWizardPage_ErrorMessage_NoValidExistingConfiguration, 3);
                } else if (this.folderText.getText() == null || this.folderText.getText().equals(SelectConfigurationFileWizardPage.EMPTY_STRING)) {
                    SelectConfigurationFileWizardPage.this.setPageComplete(false);
                    SelectConfigurationFileWizardPage.this.setMessage("Please select a valid folder", 3);
                } else {
                    super.validatePage();
                }
            }
        }

        public Document generateInitialContent() {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                IPath location;
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.createFromExistingConfigurationText.getText()));
                if (iFile.exists() && (location = iFile.getLocation()) != null) {
                    File file = location.toFile();
                    Document document = documentBuilder.parse(file);
                    return document;
                }
            }
            catch (ParserConfigurationException e) {
                Activator.log.error((Throwable)e);
            }
            catch (SAXException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
            return null;
        }

        public File getNewFile() {
            Path path = new Path(this.folderText.getText());
            IContainer iContainer = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (iContainer.exists()) {
                IPath location = iContainer.getLocation();
                File file = location.append(Character.toString('/')).append(this.nameText.getText()).addFileExtension("xml").toFile();
                return file;
            }
            Activator.log.warn("should never enter here");
            File file = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().append(this.folderText.getText()).append(Character.toString('/')).append(this.nameText.getText()).addFileExtension("xml").toFile();
            return file;
        }

        public void performPostSerializationAction() {
        }
    }

    protected class CreateFromScratchArea
    extends AbstractNameConfigurationArea {
        protected Button createFromScratchButton;
        protected Text pluginIdText;
        protected Text folderText;
        protected Button folderButton;

        protected CreateFromScratchArea() {
        }

        public void setEnable(boolean enable) {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.createFromScratchButton)) {
                this.createFromScratchButton.setSelection(enable);
                this.nameText.setEnabled(enable);
                this.pluginIdText.setEnabled(enable);
                this.folderButton.setEnabled(enable);
                if (enable) {
                    this.nameText.selectAll();
                    this.nameText.setFocus();
                }
            }
        }

        public Composite createContent(Composite parent) {
            Composite createFromScratchComposite = new Composite(parent, 2048);
            createFromScratchComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            createFromScratchComposite.setLayout((Layout)new GridLayout(4, false));
            this.createFromScratchButton = new Button(createFromScratchComposite, 16);
            this.createFromScratchButton.addSelectionListener(SelectConfigurationFileWizardPage.this.selectionListener);
            SelectConfigurationFileWizardPage.this.radioButtonsMapping.put(this.createFromScratchButton, this);
            Label createFromScratchLabel = new Label(createFromScratchComposite, 0);
            createFromScratchLabel.setText(Messages.SelectConfigurationFileWizardPage_CreateAnEmptyConfig_Label);
            GridData labelData = new GridData(4, 4, true, false, 3, 1);
            createFromScratchLabel.setLayoutData((Object)labelData);
            Label nameLabel = new Label(createFromScratchComposite, 0);
            nameLabel.setText(Messages.SelectConfigurationFileWizardPage_CreateAnEmptyConfigName_Label);
            nameLabel.setToolTipText(Messages.SelectConfigurationFileWizardPage_CreateAnEmptyConfigName_Tooltip);
            labelData = new GridData(4, 0x1000000, false, false, 2, 1);
            nameLabel.setLayoutData((Object)labelData);
            this.nameText = new Text(createFromScratchComposite, 2048);
            this.nameText.setText(Messages.SelectConfigurationFileWizardPage_CreateAnEmptyConfigName_DefaultValue);
            GridData textData = new GridData(4, 4, true, false, 2, 1);
            this.nameText.setLayoutData((Object)textData);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateFromScratchArea.this.validatePage();
                }
            });
            Label pluginIdLabel = new Label(createFromScratchComposite, 0);
            pluginIdLabel.setText(Messages.SelectConfigurationFileWizardPage_CreateAnEmptyConfigPluginId_Label);
            pluginIdLabel.setToolTipText(Messages.SelectConfigurationFileWizardPage_CreateAnEmptyConfigPluginId_Tooltip);
            labelData = new GridData(4, 0x1000000, false, false, 2, 1);
            pluginIdLabel.setLayoutData((Object)labelData);
            this.pluginIdText = new Text(createFromScratchComposite, 2048);
            this.pluginIdText.setText(Messages.SelectConfigurationFileWizardPage_CreateAnEmptyConfigPluginId_DefaultValue);
            this.pluginIdText.setLayoutData((Object)textData);
            this.pluginIdText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateFromScratchArea.this.validatePage();
                }
            });
            Label folderLabel = new Label(createFromScratchComposite, 0);
            folderLabel.setText("Folder:");
            folderLabel.setToolTipText("Select the folder where you want to create the new file");
            labelData = new GridData(4, 0x1000000, false, false, 2, 1);
            folderLabel.setLayoutData((Object)labelData);
            this.folderText = new Text(createFromScratchComposite, 2048);
            this.folderText.setText(SelectConfigurationFileWizardPage.EMPTY_STRING);
            this.folderText.setEditable(false);
            textData = new GridData(4, 4, true, false, 1, 1);
            this.folderText.setLayoutData((Object)textData);
            this.folderButton = new Button(createFromScratchComposite, 0);
            this.folderButton.setText("Select...");
            this.folderButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ContainerSelectionDialog selectionDialog = new ContainerSelectionDialog(SelectConfigurationFileWizardPage.this.getShell(), null, true, "Select the container where the file will be created");
                    if (selectionDialog.open() == 0) {
                        Object[] result = selectionDialog.getResult();
                        if (result.length < 1) {
                            Activator.log.error("no container was selected in the dialog", null);
                            return;
                        }
                        Object container = result[0];
                        if (container instanceof Path) {
                            Path path = (Path)container;
                            CreateFromScratchArea.this.folderText.setText(path.toString());
                        }
                        CreateFromScratchArea.this.validatePage();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return createFromScratchComposite;
        }

        public String getPluginId() {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.pluginIdText)) {
                return this.pluginIdText.getText();
            }
            Activator.log.error("impossible to read plugin Id from the text area", null);
            return SelectConfigurationFileWizardPage.EMPTY_STRING;
        }

        public File getNewFile() {
            Path path = new Path(this.folderText.getText());
            IContainer iContainer = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (iContainer.exists()) {
                IPath location = iContainer.getLocation();
                File file = location.append(Character.toString('/')).append(this.nameText.getText()).addFileExtension("xml").toFile();
                return file;
            }
            Activator.log.warn("should never enter here");
            File file = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().append(this.folderText.getText()).append(Character.toString('/')).append(this.nameText.getText()).addFileExtension("xml").toFile();
            return file;
        }

        public Document generateInitialContent() {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Comment comment = document.createComment(Messages.bind((String)Messages.SelectConfigurationFileWizardPage_EmptyDocument_InitialComment, (Object)Calendar.getInstance().getTime()));
                document.appendChild(comment);
                Element rootNode = document.createElement("propertyTabView");
                rootNode.setAttribute("pluginId", this.pluginIdText.getText());
                document.appendChild(rootNode);
                document.normalizeDocument();
                return document;
            }
            catch (ParserConfigurationException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public void validatePage() {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.nameText)) {
                if (this.pluginIdText.getText() == null || this.pluginIdText.getText().equals(SelectConfigurationFileWizardPage.EMPTY_STRING)) {
                    SelectConfigurationFileWizardPage.this.setPageComplete(false);
                    SelectConfigurationFileWizardPage.this.setMessage(Messages.SelectConfigurationFileWizardPage_ErrorMessage_NoValidPluginIdentifier, 3);
                } else if (this.folderText.getText() == null || this.folderText.getText().equals(SelectConfigurationFileWizardPage.EMPTY_STRING)) {
                    SelectConfigurationFileWizardPage.this.setPageComplete(false);
                    SelectConfigurationFileWizardPage.this.setMessage("Please select a valid folder", 3);
                } else {
                    super.validatePage();
                }
            }
        }

        public void performPostSerializationAction() {
        }
    }

    protected static interface IConfigurationArea {
        public void setEnable(boolean var1);

        public void validatePage();

        public Document generateInitialContent();

        public Composite createContent(Composite var1);

        public File getNewFile();

        public void performPostSerializationAction();
    }

    protected static interface INameConfigurationArea
    extends IConfigurationArea {
        public String getNewName();
    }

    public class ModifyExistingConfigurationArea
    implements IConfigurationArea {
        protected Text modifyExistingConfigurationText;
        protected Button modifyExistingConfigurationSelectionButton;
        protected Button modifyExistingConfigurationButton;

        public void setEnable(boolean enable) {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.modifyExistingConfigurationButton)) {
                this.modifyExistingConfigurationButton.setSelection(enable);
                this.modifyExistingConfigurationText.setEnabled(enable);
                this.modifyExistingConfigurationSelectionButton.setEnabled(enable);
            }
        }

        public void validatePage() {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.modifyExistingConfigurationText)) {
                if (this.modifyExistingConfigurationText.getText() == null || this.modifyExistingConfigurationText.getText().equals(SelectConfigurationFileWizardPage.EMPTY_STRING)) {
                    SelectConfigurationFileWizardPage.this.setPageComplete(false);
                    SelectConfigurationFileWizardPage.this.setMessage(Messages.SelectConfigurationFileWizardPage_ErrorMessage_NoValidExistingConfiguration, 3);
                } else {
                    SelectConfigurationFileWizardPage.this.setMessage(SelectConfigurationFileWizardPage.EMPTY_STRING, 0);
                    SelectConfigurationFileWizardPage.this.setPageComplete(true);
                }
            }
        }

        public Composite createContent(Composite parent) {
            Composite modifyExistingConfigurationComposite = new Composite(parent, 2048);
            modifyExistingConfigurationComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            modifyExistingConfigurationComposite.setLayout((Layout)new GridLayout(3, false));
            this.modifyExistingConfigurationButton = new Button(modifyExistingConfigurationComposite, 16);
            this.modifyExistingConfigurationButton.addSelectionListener(SelectConfigurationFileWizardPage.this.selectionListener);
            SelectConfigurationFileWizardPage.this.radioButtonsMapping.put(this.modifyExistingConfigurationButton, this);
            Label modifyExistingConfigurationLabel = new Label(modifyExistingConfigurationComposite, 0);
            modifyExistingConfigurationLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            modifyExistingConfigurationLabel.setText(Messages.SelectConfigurationFileWizardPage_ModifyExistingConfiguration_Label);
            this.modifyExistingConfigurationText = new Text(modifyExistingConfigurationComposite, 2056);
            this.modifyExistingConfigurationText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.modifyExistingConfigurationSelectionButton = new Button(modifyExistingConfigurationComposite, 0);
            this.modifyExistingConfigurationSelectionButton.setText(Messages.SelectConfigurationFileWizardPage_ModifyExistingConfigurationSelectionButton_Label);
            this.modifyExistingConfigurationSelectionButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IFile[] selectedFiles = WorkspaceResourceDialog.openFileSelection((Shell)SelectConfigurationFileWizardPage.this.getShell(), (String)Messages.SelectConfigurationFileWizardPage_ModifyExistingConfig_Dialog_Title, (String)Messages.SelectConfigurationFileWizardPage_ModifyExistingConfig_Dialog_Message, (boolean)false, (Object[])new Object[0], Collections.singletonList(((ModifyExistingConfigurationArea)ModifyExistingConfigurationArea.this).SelectConfigurationFileWizardPage.this.fileViewerFilter));
                    if (selectedFiles != null && selectedFiles.length == 1) {
                        IFile selectedFile = selectedFiles[0];
                        ModifyExistingConfigurationArea.this.modifyExistingConfigurationText.setText(selectedFile.getFullPath().toString());
                        ModifyExistingConfigurationArea.this.validatePage();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return modifyExistingConfigurationComposite;
        }

        public Document generateInitialContent() {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                IPath location;
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.modifyExistingConfigurationText.getText()));
                if (iFile.exists() && (location = iFile.getLocation()) != null) {
                    File file = location.toFile();
                    Document document = documentBuilder.parse(file);
                    return document;
                }
            }
            catch (ParserConfigurationException e) {
                Activator.log.error((Throwable)e);
            }
            catch (SAXException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
            return null;
        }

        public File getNewFile() {
            IPath location;
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.modifyExistingConfigurationText.getText()));
            if (iFile.exists() && (location = iFile.getLocation()) != null) {
                return location.toFile();
            }
            Activator.log.warn("should not get the file using this method");
            return ResourcesPlugin.getWorkspace().getRoot().getRawLocation().append(this.modifyExistingConfigurationText.getText()).toFile();
        }

        public void performPostSerializationAction() {
        }
    }

    public class ModifyPluginConfigurationArea
    implements IConfigurationArea {
        protected Text modifyPluginConfigurationText;
        protected Button modifyPluginConfigurationSelectionButton;
        protected Button modifyPluginConfigurationButton;
        private File file;

        public void setEnable(boolean enable) {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.modifyPluginConfigurationButton)) {
                this.modifyPluginConfigurationButton.setSelection(enable);
                this.modifyPluginConfigurationText.setEnabled(enable);
                this.modifyPluginConfigurationSelectionButton.setEnabled(enable);
            }
        }

        public void validatePage() {
            if (SelectConfigurationFileWizardPage.this.isValid((Control)this.modifyPluginConfigurationText)) {
                if (this.modifyPluginConfigurationText.getText() == null || this.modifyPluginConfigurationText.getText().equals(SelectConfigurationFileWizardPage.EMPTY_STRING)) {
                    SelectConfigurationFileWizardPage.this.setPageComplete(false);
                    SelectConfigurationFileWizardPage.this.setMessage(Messages.SelectConfigurationFileWizardPage_ErrorMessage_NoValidExistingConfiguration, 3);
                } else {
                    SelectConfigurationFileWizardPage.this.setMessage(SelectConfigurationFileWizardPage.EMPTY_STRING, 0);
                    SelectConfigurationFileWizardPage.this.setPageComplete(true);
                }
            }
        }

        public Composite createContent(Composite parent) {
            Composite modifyExistingConfigurationComposite = new Composite(parent, 2048);
            modifyExistingConfigurationComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            modifyExistingConfigurationComposite.setLayout((Layout)new GridLayout(3, false));
            this.modifyPluginConfigurationButton = new Button(modifyExistingConfigurationComposite, 16);
            this.modifyPluginConfigurationButton.addSelectionListener(SelectConfigurationFileWizardPage.this.selectionListener);
            SelectConfigurationFileWizardPage.this.radioButtonsMapping.put(this.modifyPluginConfigurationButton, this);
            Label modifyExistingConfigurationLabel = new Label(modifyExistingConfigurationComposite, 0);
            modifyExistingConfigurationLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            modifyExistingConfigurationLabel.setText("Modify plugin contribution");
            this.modifyPluginConfigurationText = new Text(modifyExistingConfigurationComposite, 2056);
            this.modifyPluginConfigurationText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.modifyPluginConfigurationSelectionButton = new Button(modifyExistingConfigurationComposite, 0);
            this.modifyPluginConfigurationSelectionButton.setText(Messages.SelectConfigurationFileWizardPage_ModifyExistingConfigurationSelectionButton_Label);
            this.modifyPluginConfigurationSelectionButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<XMLPropertyTabViewProvider> tabViewProviders = new ArrayList<XMLPropertyTabViewProvider>();
                    for (Object provider : PropertyViewService.getInstance().getPropertyViewProviders()) {
                        PropertyViewService.ProviderDescriptor descriptor = (PropertyViewService.ProviderDescriptor)provider;
                        if (!(descriptor.getProvider() instanceof XMLPropertyTabViewProvider)) continue;
                        tabViewProviders.add((XMLPropertyTabViewProvider)descriptor.getProvider());
                    }
                    ProviderSelectionDialog dialog = new ProviderSelectionDialog(SelectConfigurationFileWizardPage.this.getShell(), tabViewProviders);
                    if (dialog.open() == 0 && dialog.getFirstResult() != null) {
                        ModifyPluginConfigurationArea.this.modifyPluginConfigurationText.setText(((XMLPropertyTabViewProvider)dialog.getFirstResult()).getId());
                    }
                    ModifyPluginConfigurationArea.this.validatePage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return modifyExistingConfigurationComposite;
        }

        public Document generateInitialContent() {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                XMLPropertyTabViewProvider provider = this.retrieveProvider();
                if (provider != null) {
                    Document document = documentBuilder.parse(provider.getConfigurationContent());
                    return document;
                }
                Activator.log.error("provider niot found. Impossible to edit", null);
            }
            catch (ParserConfigurationException e) {
                Activator.log.error((Throwable)e);
            }
            catch (SAXException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
            return null;
        }

        protected XMLPropertyTabViewProvider retrieveProvider() {
            for (PropertyViewService.ProviderDescriptor descriptor : PropertyViewService.getInstance().getPropertyViewProviders()) {
                String id;
                IProvider provider = descriptor.getProvider();
                if (!(provider instanceof XMLPropertyTabViewProvider) || !(id = ((XMLPropertyTabViewProvider)provider).getId()).equals(this.modifyPluginConfigurationText.getText())) continue;
                return (XMLPropertyTabViewProvider)provider;
            }
            return null;
        }

        protected PropertyViewService.ProviderDescriptor retrieveProviderDescriptor() {
            for (PropertyViewService.ProviderDescriptor descriptor : PropertyViewService.getInstance().getPropertyViewProviders()) {
                String id;
                IProvider provider = descriptor.getProvider();
                if (!(provider instanceof XMLPropertyTabViewProvider) || !(id = ((XMLPropertyTabViewProvider)provider).getId()).equals(this.modifyPluginConfigurationText.getText())) continue;
                return descriptor;
            }
            return null;
        }

        public File getNewFile() {
            XMLPropertyTabViewProvider provider = this.retrieveProvider();
            if (provider == null) {
                return null;
            }
            if (this.file == null) {
                this.file = provider.getLocalXmlfile(String.valueOf(provider.getId()) + "_" + System.currentTimeMillis() + ".xml");
            }
            return this.file;
        }

        public void performPostSerializationAction() {
            XMLPropertyTabViewProvider provider = this.retrieveProvider();
            if (provider == null) {
                Activator.log.error("Impossible to find the provider to customize...", null);
                return;
            }
            provider.setConfigurationFile(this.getNewFile());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProviderSelectionDialog
    extends FilteredItemsSelectionDialog {
        private final List<XMLPropertyTabViewProvider> providers;
        private ProviderLabelProvider providerLabelProvider;
        private ProviderDetailsLabelProvider providerDetailsLabelProvider;

        public ProviderSelectionDialog(Shell shell, List<XMLPropertyTabViewProvider> providers) {
            super(shell, false);
            this.providers = providers;
            this.providerLabelProvider = new ProviderLabelProvider();
            this.providerDetailsLabelProvider = new ProviderDetailsLabelProvider();
            this.setListLabelProvider((ILabelProvider)this.providerLabelProvider);
            this.setDetailsLabelProvider((ILabelProvider)this.providerDetailsLabelProvider);
            this.setInitialPattern("**");
        }

        protected IStatus validateItem(Object item) {
            return Status.OK_STATUS;
        }

        protected Comparator<XMLPropertyTabViewProvider> getItemsComparator() {
            return new Comparator<XMLPropertyTabViewProvider>(){

                @Override
                public int compare(XMLPropertyTabViewProvider o1, XMLPropertyTabViewProvider o2) {
                    return o1.getContributionName().compareTo(o2.getContributionName());
                }
            };
        }

        public String getElementName(Object item) {
            return this.providerLabelProvider.getText(item);
        }

        protected IDialogSettings getDialogSettings() {
            return Activator.getDefault().getDialogSettings();
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
            if (progressMonitor != null) {
                progressMonitor.beginTask("Displaying Providers elements", this.providers.size());
            }
            for (XMLPropertyTabViewProvider provider : this.providers) {
                contentProvider.add((Object)provider, itemsFilter);
                progressMonitor.worked(1);
            }
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new FilteredItemsSelectionDialog.ItemsFilter(this){

                public boolean matchItem(Object item) {
                    if (!(item instanceof XMLPropertyTabViewProvider)) {
                        return false;
                    }
                    return this.matches(ProviderSelectionDialog.this.providerLabelProvider.getText((XMLPropertyTabViewProvider)item));
                }

                public boolean isConsistentItem(Object item) {
                    return item instanceof XMLPropertyTabViewProvider;
                }
            };
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected class ProviderDetailsLabelProvider
        extends ProviderLabelProvider {
            protected ProviderDetailsLabelProvider() {
            }

            public String getText(Object element) {
                if (element instanceof XMLPropertyTabViewProvider) {
                    return String.valueOf(((XMLPropertyTabViewProvider)element).getContributionName()) + " - " + ((XMLPropertyTabViewProvider)element).getId();
                }
                return super.getText(element);
            }
        }

        protected class ProviderLabelProvider
        extends LabelProvider {
            protected ProviderLabelProvider() {
            }

            public String getText(Object element) {
                if (element instanceof XMLPropertyTabViewProvider) {
                    return ((XMLPropertyTabViewProvider)element).getContributionName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof XMLPropertyTabViewProvider) {
                    return Activator.getImage("/icons/plugin_desc.gif");
                }
                return super.getImage(element);
            }
        }
    }

    protected class RadioSelectionListener
    implements SelectionListener {
        protected RadioSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SelectConfigurationFileWizardPage.this.notifyButtonChanged(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    protected class XMLFileViewerFilter
    extends ViewerFilter {
        protected static final String XML_FILE_EXTENSION = "xml";

        protected XMLFileViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return XML_FILE_EXTENSION.equals(file.getFileExtension());
            }
            return true;
        }
    }
}

