/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog.actions;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerService;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.ControllerDescriptorState;
import org.eclipse.papyrus.properties.runtime.controller.predefined.PredefinedControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.predefined.PredefinedControllerState;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.AppliedStereotypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.ContentHolder;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.AbstractMenuCreator;
import org.eclipse.papyrus.properties.tabbed.customization.state.ConstraintStateUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Stereotype;

public class ContainerMenuCreator
extends AbstractMenuCreator {
    private final ContainerDescriptorState containerDescriptorState;
    private MenuManager manager;

    public ContainerMenuCreator(ContainerDescriptorState containerDescriptorState, SectionSetDescriptorState sectionSetDescriptorState, EClassifier currentMetaclass, Stereotype currentStereotype) {
        super(sectionSetDescriptorState, currentMetaclass, currentStereotype);
        this.containerDescriptorState = containerDescriptorState;
    }

    public Menu getMenu(final Control parent) {
        Menu menu;
        if (this.manager == null) {
            this.manager = new MenuManager();
        }
        if ((menu = this.manager.getMenu()) != null) {
            menu.dispose();
            menu = null;
        }
        this.manager.removeAll();
        menu = this.manager.createContextMenu(parent);
        Action removeAction = new Action("Remove Container", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/delete.gif")){

            public void run() {
                if (parent instanceof Tree) {
                    TreeItem[] selectedItems = ((Tree)parent).getSelection();
                    if (selectedItems.length < 1) {
                        Activator.log.warn("Impossible to find the current selection in the tree");
                        return;
                    }
                    TreeItem selectedItem = selectedItems[0];
                    TreeItem parentItem = selectedItem.getParentItem();
                    if (parentItem == null) {
                        Activator.log.warn("Impossible to find the parent for current selection in the tree ");
                        return;
                    }
                    Object parent2 = parentItem.getData();
                    if (parent2 instanceof FragmentDescriptorState) {
                        ((FragmentDescriptorState)parent2).removeContainerDescriptorState(ContainerMenuCreator.this.containerDescriptorState);
                    }
                }
            }

            public boolean isEnabled() {
                ContainerDescriptorState state = ContainerMenuCreator.this.getSelectedContainerDescriptorState(parent);
                if (state == null || state.isReadOnly()) {
                    this.setEnabled(false);
                }
                return super.isEnabled();
            }
        };
        this.manager.add((IAction)removeAction);
        this.manager.add((IContributionItem)new Separator("addGroup"));
        ContainerDescriptorState state = this.getSelectedContainerDescriptorState(parent);
        if (state == null || state.isReadOnly()) {
            return menu;
        }
        Class selectionClass = null;
        List appliedStereotypes = null;
        if (parent instanceof Tree) {
            Object rootElement;
            Tree tree = (Tree)parent;
            TreeItem[] items = tree.getSelection();
            if (items.length < 1) {
                Activator.log.warn("impossible to find an element in the selection");
                return menu;
            }
            TreeItem root = this.retrieveRoot(items[0]);
            if (root != null && (rootElement = root.getData()) instanceof ContentHolder) {
                List constraintDescriptorStates = ((ContentHolder)((Object)rootElement)).getSectionSetDescriptorState().getConstraintDescriptorStates();
                for (ConstraintDescriptorState constraintDescriptorState : constraintDescriptorStates) {
                    IConstraintDescriptor descriptor = constraintDescriptorState.getDescriptor();
                    if (descriptor instanceof ObjectTypeConstraintDescriptor) {
                        selectionClass = ((ObjectTypeConstraintDescriptor)descriptor).getElementClass();
                        continue;
                    }
                    if (!(descriptor instanceof AppliedStereotypeConstraintDescriptor)) continue;
                    appliedStereotypes = ((AppliedStereotypeConstraintDescriptor)descriptor).getStereotypeQualifiedNames();
                }
            }
        }
        Map predefinedDescriptors = PropertyEditorControllerService.getInstance().getAllPredefinedControllers();
        for (String predefinedId : predefinedDescriptors.keySet()) {
            final PredefinedControllerDescriptor propertyEditorControllerDescriptor = (PredefinedControllerDescriptor)predefinedDescriptors.get(predefinedId);
            List constraints = propertyEditorControllerDescriptor.getConstraintDescriptors();
            boolean isValid = ConstraintStateUtils.areCompatible(constraints, this.getSectionSetDescriptorState().getConstraintDescriptorStates());
            if (!isValid) continue;
            Action action = new Action("Add " + propertyEditorControllerDescriptor.getText() + " (" + propertyEditorControllerDescriptor.getPredefinedId() + ")", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewPredefinedController.gif")){

                public void run() {
                    if (parent instanceof Tree) {
                        TreeItem[] selectedItems = ((Tree)parent).getSelection();
                        if (selectedItems.length < 1) {
                            Activator.log.warn("Impossible to find the current selection in the tree");
                            return;
                        }
                        PredefinedControllerState state = new PredefinedControllerState(propertyEditorControllerDescriptor, false);
                        ContainerMenuCreator.this.containerDescriptorState.addPropertyEditorControllerState((ControllerDescriptorState)state);
                    }
                }
            };
            this.manager.appendToGroup("addGroup", (IAction)action);
        }
        return menu;
    }

    protected TreeItem retrieveRoot(TreeItem item) {
        if (item.getParentItem() == null) {
            return item;
        }
        return this.retrieveRoot(item.getParentItem());
    }

    protected ContainerDescriptorState getSelectedContainerDescriptorState(Object parent) {
        if (parent instanceof Tree) {
            TreeItem[] selectedItems = ((Tree)parent).getSelection();
            if (selectedItems.length < 1) {
                Activator.log.warn("Impossible to find the current selection in the tree");
                return null;
            }
            TreeItem selectedItem = selectedItems[0];
            Object data = selectedItem.getData();
            if (data instanceof ContainerDescriptorState) {
                return (ContainerDescriptorState)data;
            }
        }
        return null;
    }

    public void dispose() {
        Menu menu;
        if (this.manager != null && (menu = this.manager.getMenu()) != null) {
            menu.dispose();
            Object var1_1 = null;
        }
    }
}

