/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.papyrus.properties.runtime.dialogs.PropertyDialog;
import org.eclipse.papyrus.properties.runtime.state.IState;
import org.eclipse.papyrus.properties.runtime.view.DialogDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewService;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.PropertyServiceUtil;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.ContentHolder;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.AbstractMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHolderMenuCreator
extends AbstractMenuCreator {
    private final ContentHolder contentHolder;
    private MenuManager manager;

    public ContentHolderMenuCreator(ContentHolder contentHolder, SectionSetDescriptorState sectionSetDescriptorState, EClassifier currentMetaclass, Stereotype currentStereotype) {
        super(sectionSetDescriptorState, currentMetaclass, currentStereotype);
        this.contentHolder = contentHolder;
    }

    public Menu getMenu(Control parent) {
        Menu menu;
        if (this.manager == null) {
            this.manager = new MenuManager();
        }
        if ((menu = this.manager.getMenu()) != null) {
            menu.dispose();
            menu = null;
        }
        this.manager.removeAll();
        menu = this.manager.createContextMenu(parent);
        SectionSetDescriptorState currentSectionSetDescriptorState = this.getSectionSetDescriptorState();
        if (currentSectionSetDescriptorState == null) {
            return menu;
        }
        final int selectionSize = currentSectionSetDescriptorState.getSelectionSize();
        Action action = new Action("Add Section", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewSection.gif")){

            public void run() {
                DynamicSectionDescriptor descriptor = new DynamicSectionDescriptor(ContentHolderMenuCreator.this.getNewSectionId(ContentHolderMenuCreator.this.getCurrentMetaclass(), ContentHolderMenuCreator.this.getCurrentStereotype(), selectionSize), ContentHolderMenuCreator.this.getDefaultTabId(), new ArrayList(), 1, "Semantic", new ArrayList(), null, new ArrayList());
                SectionDescriptorState sectionDescriptorState = new SectionDescriptorState(descriptor, false);
                ContentHolderMenuCreator.this.contentHolder.getSectionSetDescriptorState().addSectionDescriptorState(sectionDescriptorState);
            }
        };
        this.manager.add((IAction)action);
        return menu;
    }

    protected void openSectionConfigurationDialog(IState iState) {
        DialogDescriptor descriptor = PropertyViewService.getInstance().getDialogDescriptor(iState.getEditionDialogId());
        ArrayList<IState> objectsToEdit = new ArrayList<IState>();
        objectsToEdit.add(iState);
        if (descriptor != null) {
            Shell parentShell = Display.getCurrent().getActiveShell();
            PropertyDialog dialog = new PropertyDialog(parentShell, descriptor, objectsToEdit, new TabbedPropertySheetWidgetFactory());
            dialog.open();
        } else {
            Activator.log.warn("impossible to find an editor for element: " + iState);
        }
    }

    @Override
    public Menu getMenu(Menu parent) {
        return null;
    }

    protected String getNewSectionId(EClassifier classifier, Stereotype stereotype, int selectionSize) {
        int i = 0;
        while (i < 1000) {
            boolean found = false;
            StringBuffer buffer = new StringBuffer();
            buffer.append("section_");
            if (selectionSize == 1) {
                buffer.append("single");
            } else if (selectionSize < 0) {
                buffer.append("multi");
            } else {
                buffer.append(selectionSize);
            }
            buffer.append("_");
            if (classifier != null && classifier.getInstanceClass().getSimpleName() != null) {
                buffer.append(classifier.getInstanceClass().getSimpleName());
            } else if (stereotype != null && stereotype.getQualifiedName() != null) {
                buffer.append(stereotype.getQualifiedName());
            } else {
                buffer.append("NoName");
            }
            if (i > 0) {
                buffer.append(i);
            }
            String name = buffer.toString();
            for (SectionDescriptorState sectionDescriptorState : this.contentHolder.getSectionSetDescriptorState().getSectionDescriptorStates()) {
                String id = sectionDescriptorState.getDescriptor().getId();
                if (!name.equalsIgnoreCase(id)) continue;
                found = true;
            }
            if (!found) {
                return name;
            }
            ++i;
        }
        return "";
    }

    protected String getDefaultTabId() {
        for (List descriptors : PropertyServiceUtil.getTabDescriptors()) {
            Iterator it = descriptors.iterator();
            if (!it.hasNext()) continue;
            return ((ITabDescriptor)it.next()).getId();
        }
        return "";
    }

    public void dispose() {
        Menu menu;
        if (this.manager != null && (menu = this.manager.getMenu()) != null) {
            menu.dispose();
            Object var1_1 = null;
        }
    }

    protected SectionSetDescriptorState getCurrentSectionSetDescriptorState(Object parent) {
        if (parent instanceof Tree) {
            Object rootElement;
            Tree tree = (Tree)parent;
            TreeItem[] items = tree.getSelection();
            if (items.length < 1) {
                Activator.log.warn("impossible to find an element in the selection");
                return null;
            }
            TreeItem root = this.retrieveRoot(items[0]);
            if (root != null && (rootElement = root.getData()) instanceof ContentHolder) {
                return ((ContentHolder)((Object)rootElement)).getSectionSetDescriptorState();
            }
        }
        return null;
    }

    protected TreeItem retrieveRoot(TreeItem item) {
        if (item.getParentItem() == null) {
            return item;
        }
        return this.retrieveRoot(item.getParentItem());
    }

    protected List<ConstraintDescriptorState> getConstraintDescriptorStates(Object parent) {
        SectionSetDescriptorState state = this.getCurrentSectionSetDescriptorState(parent);
        if (state != null) {
            return state.getConstraintDescriptorStates();
        }
        return Collections.emptyList();
    }
}

