/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog.actions;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.ControllerDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.AbstractMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Stereotype;

public class ControllerMenuCreator
extends AbstractMenuCreator {
    private final ControllerDescriptorState controllerDescriptorState;
    private MenuManager manager;

    public ControllerMenuCreator(ControllerDescriptorState controllerDescriptorState, SectionSetDescriptorState sectionSetDescriptorState, EClassifier currentMetaclass, Stereotype currentStereotype) {
        super(sectionSetDescriptorState, currentMetaclass, currentStereotype);
        this.controllerDescriptorState = controllerDescriptorState;
    }

    public Menu getMenu(final Control parent) {
        Menu menu;
        if (this.manager == null) {
            this.manager = new MenuManager();
        }
        if ((menu = this.manager.getMenu()) != null) {
            menu.dispose();
            menu = null;
        }
        this.manager.removeAll();
        menu = this.manager.createContextMenu(parent);
        Action removeAction = new Action("Remove Controller", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/delete.gif")){

            public void run() {
                if (parent instanceof Tree) {
                    TreeItem[] selectedItems = ((Tree)parent).getSelection();
                    if (selectedItems.length < 1) {
                        Activator.log.warn("Impossible to find the current selection in the tree");
                        return;
                    }
                    TreeItem selectedItem = selectedItems[0];
                    TreeItem parentItem = selectedItem.getParentItem();
                    if (parentItem == null) {
                        Activator.log.warn("Impossible to find the parent for current selection in the tree ");
                        return;
                    }
                    Object parent2 = parentItem.getData();
                    if (parent2 instanceof ContainerDescriptorState) {
                        ((ContainerDescriptorState)parent2).removePropertyEditorControllerState(ControllerMenuCreator.this.controllerDescriptorState);
                    }
                }
            }

            public boolean isEnabled() {
                if (this.getSelectedControllerState() == null || this.getSelectedControllerState().isReadOnly()) {
                    this.setEnabled(false);
                }
                return super.isEnabled();
            }

            protected ControllerDescriptorState getSelectedControllerState() {
                if (parent instanceof Tree) {
                    TreeItem[] selectedItems = ((Tree)parent).getSelection();
                    if (selectedItems.length < 1) {
                        Activator.log.warn("Impossible to find the current selection in the tree");
                        return null;
                    }
                    TreeItem selectedItem = selectedItems[0];
                    Object data = selectedItem.getData();
                    if (data instanceof ControllerDescriptorState) {
                        return (ControllerDescriptorState)data;
                    }
                }
                return null;
            }
        };
        this.manager.add((IAction)removeAction);
        this.manager.add((IContributionItem)new Separator("addGroup"));
        return menu;
    }

    public void dispose() {
        Menu menu;
        if (this.manager != null && (menu = this.manager.getMenu()) != null) {
            menu.dispose();
            Object var1_1 = null;
        }
    }
}

