/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.AbstractMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EClassifierMenuCreator
extends AbstractMenuCreator {
    private final ModelElementItem item;
    private MenuManager manager;
    private final List<SectionSetDescriptorState> sectionSetDescriptorStates;
    private TreeViewer treeViewer;

    public EClassifierMenuCreator(ModelElementItem item, List<SectionSetDescriptorState> sectionSetDescriptorStates, TreeViewer treeViewer, SectionSetDescriptorState sectionSetDescriptorState, EClassifier currentMetaclass, Stereotype currentStereotype) {
        super(sectionSetDescriptorState, currentMetaclass, currentStereotype);
        this.item = item;
        this.sectionSetDescriptorStates = sectionSetDescriptorStates;
        this.treeViewer = treeViewer;
    }

    public void dispose() {
        Menu menu;
        if (this.manager != null && (menu = this.manager.getMenu()) != null) {
            menu.dispose();
            Object var1_1 = null;
        }
    }

    public Menu getMenu(Control parent) {
        Menu menu;
        if (this.manager == null) {
            this.manager = new MenuManager();
        }
        if ((menu = this.manager.getMenu()) != null) {
            menu.dispose();
            menu = null;
        }
        this.manager.removeAll();
        menu = this.manager.createContextMenu(parent);
        Action createAction = new Action("Create Section Set for single selection", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewSectionSet.gif")){

            public void run() {
                ArrayList<ObjectTypeConstraintDescriptor> constraints = new ArrayList<ObjectTypeConstraintDescriptor>();
                EClassifier classifier = (EClassifier)EClassifierMenuCreator.this.item.getEObject();
                String qualifiedInstanceClassName = classifier.getInstanceClassName();
                try {
                    Class<?> metamodelClass = Class.forName(qualifiedInstanceClassName);
                    ObjectTypeConstraintDescriptor constraintDescriptor = new ObjectTypeConstraintDescriptor(metamodelClass);
                    constraints.add(constraintDescriptor);
                    SectionSetDescriptor descriptor = new SectionSetDescriptor(EClassifierMenuCreator.this.getNewSectionSetName(1), new ArrayList(), constraints, 1);
                    SectionSetDescriptorState state = descriptor.createState(false);
                    EClassifierMenuCreator.this.sectionSetDescriptorStates.add(state);
                    EClassifierMenuCreator.this.treeViewer.refresh();
                    EClassifierMenuCreator.this.treeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{EClassifierMenuCreator.this.item, state})));
                }
                catch (ClassNotFoundException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        };
        this.manager.add((IContributionItem)new Separator("addGroup"));
        this.manager.appendToGroup("addGroup", (IAction)createAction);
        Action createMultipleElementAction = new Action("Create Section Set for multiple selection", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewSectionSet.gif")){

            public void run() {
                ArrayList<ObjectTypeConstraintDescriptor> constraints = new ArrayList<ObjectTypeConstraintDescriptor>();
                EClassifier classifier = (EClassifier)EClassifierMenuCreator.this.item.getEObject();
                String qualifiedInstanceClassName = classifier.getInstanceClassName();
                try {
                    Class<?> metamodelClass = Class.forName(qualifiedInstanceClassName);
                    ObjectTypeConstraintDescriptor constraintDescriptor = new ObjectTypeConstraintDescriptor(metamodelClass);
                    constraints.add(constraintDescriptor);
                    SectionSetDescriptor descriptor = new SectionSetDescriptor(EClassifierMenuCreator.this.getNewSectionSetName(-1), new ArrayList(), constraints, -1);
                    SectionSetDescriptorState state = descriptor.createState(false);
                    EClassifierMenuCreator.this.sectionSetDescriptorStates.add(state);
                    EClassifierMenuCreator.this.treeViewer.refresh();
                    EClassifierMenuCreator.this.treeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{EClassifierMenuCreator.this.item, state})));
                }
                catch (ClassNotFoundException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        };
        this.manager.appendToGroup("addGroup", (IAction)createMultipleElementAction);
        return menu;
    }

    protected String getNewSectionSetName(int selectionSize) {
        int i = 0;
        while (i < 100) {
            Class selectionClass;
            boolean found = false;
            StringBuffer buffer = new StringBuffer();
            buffer.append("sectionSet_");
            if (selectionSize == 1) {
                buffer.append("single");
            } else if (selectionSize < 0) {
                buffer.append("multi");
            } else {
                buffer.append(selectionSize);
            }
            buffer.append("_");
            Class clazz = selectionClass = this.item.getEObject() instanceof EClassifier ? ((EClassifier)this.item.getEObject()).getInstanceClass() : null;
            if (selectionClass != null && selectionClass.getSimpleName() != null) {
                buffer.append(selectionClass.getSimpleName());
            } else {
                buffer.append("NoName");
            }
            if (i > 0) {
                buffer.append(i);
            }
            String name = buffer.toString();
            for (SectionSetDescriptorState sectionSetDescriptorState : this.sectionSetDescriptorStates) {
                String id = sectionSetDescriptorState.getDescriptor().getName();
                if (!name.equalsIgnoreCase(id)) continue;
                found = true;
            }
            if (!found) {
                return name;
            }
            ++i;
        }
        return "";
    }
}

