/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog.actions;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.papyrus.properties.runtime.state.IFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.content.ExpandableContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.GridLayoutDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.GroupContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.AbstractMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Stereotype;

public class FragmentMenuCreator
extends AbstractMenuCreator {
    private final FragmentDescriptorState fragmentDescriptorState;
    private MenuManager manager;

    public FragmentMenuCreator(FragmentDescriptorState fragmentDescriptorState, SectionSetDescriptorState sectionSetDescriptorState, EClassifier currentMetaclass, Stereotype currentStereotype) {
        super(sectionSetDescriptorState, currentMetaclass, currentStereotype);
        this.fragmentDescriptorState = fragmentDescriptorState;
    }

    public Menu getMenu(final Control parent) {
        Menu menu;
        if (this.manager == null) {
            this.manager = new MenuManager();
        }
        if ((menu = this.manager.getMenu()) != null) {
            menu.dispose();
            menu = null;
        }
        this.manager.removeAll();
        menu = this.manager.createContextMenu(parent);
        Action removeAction = new Action("Remove Fragment", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/delete.gif")){

            public void run() {
                if (parent instanceof Tree) {
                    TreeItem[] selectedItems = ((Tree)parent).getSelection();
                    if (selectedItems.length < 1) {
                        Activator.log.warn("Impossible to find the current selection in the tree");
                        return;
                    }
                    TreeItem selectedItem = selectedItems[0];
                    TreeItem parentItem = selectedItem.getParentItem();
                    if (parentItem == null) {
                        Activator.log.warn("Impossible to find the parent for current selection in the tree ");
                        return;
                    }
                    Object parent2 = parentItem.getData();
                    if (parent2 instanceof SectionDescriptorState) {
                        ((SectionDescriptorState)parent2).removeFragmentDescriptorState((IFragmentDescriptorState)FragmentMenuCreator.this.fragmentDescriptorState);
                    }
                }
            }
        };
        this.manager.add((IAction)removeAction);
        this.manager.add((IContributionItem)new Separator("addGroup"));
        Action addSimpleContainerAction = new Action("Add Simple Container", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewSimpleContainer.gif")){

            public void run() {
                ContainerDescriptor containerDescriptor = new ContainerDescriptor((LayoutDescriptor)new GridLayoutDescriptor(), new ArrayList());
                ContainerDescriptorState containerDescriptorState = containerDescriptor.createState(false);
                FragmentMenuCreator.this.fragmentDescriptorState.addContainerDescriptorState(containerDescriptorState);
                if (parent instanceof Tree) {
                    TreeItem[] parentItems = ((Tree)parent).getSelection();
                    if (parentItems.length < 1) {
                        return;
                    }
                    parentItems[0].setExpanded(true);
                    TreeItem[] treeItemArray = parentItems[0].getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem child = treeItemArray[n2];
                        if (containerDescriptorState.equals(child.getData())) {
                            ((Tree)parent).select(child);
                            return;
                        }
                        ++n2;
                    }
                }
            }
        };
        this.manager.appendToGroup("addGroup", (IAction)addSimpleContainerAction);
        Action addExpandableContainerAction = new Action("Add Expandable Container", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewExpandableContainer.gif")){

            public void run() {
                ExpandableContainerDescriptor containerDescriptor = new ExpandableContainerDescriptor((LayoutDescriptor)new GridLayoutDescriptor(), "Label", new ArrayList());
                ContainerDescriptorState containerDescriptorState = containerDescriptor.createState(false);
                FragmentMenuCreator.this.fragmentDescriptorState.addContainerDescriptorState(containerDescriptorState);
                if (parent instanceof Tree) {
                    TreeItem[] parentItems = ((Tree)parent).getSelection();
                    if (parentItems.length < 1) {
                        return;
                    }
                    parentItems[0].setExpanded(true);
                    TreeItem[] treeItemArray = parentItems[0].getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem child = treeItemArray[n2];
                        if (containerDescriptorState.equals(child.getData())) {
                            ((Tree)parent).select(child);
                            return;
                        }
                        ++n2;
                    }
                }
            }
        };
        this.manager.appendToGroup("addGroup", (IAction)addExpandableContainerAction);
        Action addGroupContainerAction = new Action("Add Group Container", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewGroupContainer.gif")){

            public void run() {
                GroupContainerDescriptor containerDescriptor = new GroupContainerDescriptor((LayoutDescriptor)new GridLayoutDescriptor(), "Label", new ArrayList());
                ContainerDescriptorState containerDescriptorState = containerDescriptor.createState(false);
                FragmentMenuCreator.this.fragmentDescriptorState.addContainerDescriptorState(containerDescriptorState);
                if (parent instanceof Tree) {
                    TreeItem[] parentItems = ((Tree)parent).getSelection();
                    if (parentItems.length < 1) {
                        return;
                    }
                    parentItems[0].setExpanded(true);
                    TreeItem[] treeItemArray = parentItems[0].getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem child = treeItemArray[n2];
                        if (containerDescriptorState.equals(child.getData())) {
                            ((Tree)parent).select(child);
                            return;
                        }
                        ++n2;
                    }
                }
            }
        };
        this.manager.appendToGroup("addGroup", (IAction)addGroupContainerAction);
        return menu;
    }

    public void dispose() {
        Menu menu;
        if (this.manager != null && (menu = this.manager.getMenu()) != null) {
            menu.dispose();
            Object var1_1 = null;
        }
    }
}

