/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.dialog.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.papyrus.properties.runtime.state.IFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.PredefinedFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PredefinedFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewService;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.customization.Activator;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.ContentHolder;
import org.eclipse.papyrus.properties.tabbed.customization.dialog.actions.AbstractMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Stereotype;

public class SectionMenuCreator
extends AbstractMenuCreator {
    private final SectionDescriptorState sectionDescriptorState;
    private MenuManager manager;

    public SectionMenuCreator(SectionDescriptorState sectionDescriptorState, SectionSetDescriptorState sectionSetDescriptorState, EClassifier currentMetaclass, Stereotype currentStereotype) {
        super(sectionSetDescriptorState, currentMetaclass, currentStereotype);
        this.sectionDescriptorState = sectionDescriptorState;
    }

    public void dispose() {
        Menu menu;
        if (this.manager != null && (menu = this.manager.getMenu()) != null) {
            menu.dispose();
            Object var1_1 = null;
        }
    }

    public Menu getMenu(final Control parent) {
        Menu menu;
        if (this.manager == null) {
            this.manager = new MenuManager();
        }
        if ((menu = this.manager.getMenu()) != null) {
            menu.dispose();
            menu = null;
        }
        this.manager.removeAll();
        menu = this.manager.createContextMenu(parent);
        Action removeAction = new Action("Remove Section", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/delete.gif")){

            public void run() {
                if (parent instanceof Tree) {
                    TreeItem[] selectedItems = ((Tree)parent).getSelection();
                    if (selectedItems.length < 1) {
                        Activator.log.warn("Impossible to find the curret selection in the tree");
                        return;
                    }
                    TreeItem selectedItem = selectedItems[0];
                    TreeItem parentItem = selectedItem.getParentItem();
                    if (parentItem == null) {
                        Activator.log.warn("Impossible to find the parent for current selection in the tree ");
                        return;
                    }
                    Object parent2 = parentItem.getData();
                    if (parent2 instanceof ContentHolder) {
                        SectionSetDescriptorState sectionSetDescriptorState = ((ContentHolder)((Object)parent2)).getSectionSetDescriptorState();
                        sectionSetDescriptorState.removeSectionDescriptorState(SectionMenuCreator.this.sectionDescriptorState);
                    }
                }
            }
        };
        this.manager.add((IAction)removeAction);
        this.manager.add((IContributionItem)new Separator("addGroup"));
        Class selectionClass = null;
        if (this.getCurrentMetaclass() != null) {
            selectionClass = this.getCurrentMetaclass().getInstanceClass();
        }
        Class finalSelectionClass = selectionClass;
        SectionSetDescriptorState currentSectionSetDescriptorState = this.getSectionSetDescriptorState();
        if (currentSectionSetDescriptorState == null) {
            return menu;
        }
        final List constraintDescriptorStates = this.getSectionSetDescriptorState().getConstraintDescriptorStates();
        final int selectionSize = currentSectionSetDescriptorState.getSelectionSize();
        Action addFragmentAction = new Action("Add New Fragment", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewFragment.gif")){

            public void run() {
                FragmentDescriptor fragmentDescriptor = new FragmentDescriptor(SectionMenuCreator.this.getNewFragmentId(SectionMenuCreator.this.getCurrentMetaclass(), SectionMenuCreator.this.getCurrentStereotype(), selectionSize), new ArrayList(), new ArrayList(), SectionMenuCreator.this.getSectionSetDescriptorState().getSelectionSize());
                FragmentDescriptorState fragmentDescriptorState = new FragmentDescriptorState(fragmentDescriptor, false);
                for (ConstraintDescriptorState state : constraintDescriptorStates) {
                    fragmentDescriptorState.addConstraintDescriptorState(state);
                }
                SectionMenuCreator.this.sectionDescriptorState.addFragmentDescriptorState((IFragmentDescriptorState)fragmentDescriptorState);
            }
        };
        this.manager.appendToGroup("addGroup", (IAction)addFragmentAction);
        Action addReplacedSectionAction = new Action("Add New replaced section", Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewReplacedSection.gif")){

            public void run() {
                SectionDescriptorState sectionDescriptorState = SectionMenuCreator.this.sectionDescriptorState;
                SectionDescriptorState sectionDescriptorState2 = SectionMenuCreator.this.sectionDescriptorState;
                sectionDescriptorState2.getClass();
                sectionDescriptorState.addReplacedSectionState(new SectionDescriptorState.ReplacedSectionState(sectionDescriptorState2, ""));
            }
        };
        this.manager.appendToGroup("addGroup", (IAction)addReplacedSectionAction);
        Map availableFragmentDescriptors = PropertyViewService.getInstance().getAllFragmentDescriptors();
        for (final FragmentDescriptor descriptor : availableFragmentDescriptors.values()) {
            for (IConstraintDescriptor constraintDescriptor : descriptor.getConstraintDescriptors()) {
                if (!(constraintDescriptor instanceof ObjectTypeConstraintDescriptor)) continue;
                Class elementClass = ((ObjectTypeConstraintDescriptor)constraintDescriptor).getElementClass();
                if (selectionClass == null || !elementClass.isAssignableFrom(selectionClass)) continue;
                Action addPredefinedFragmentAction = new Action("Add Predefined " + descriptor.getText(), Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.tabbed.customization", (String)"/icons/NewFragment.gif")){

                    public void run() {
                        if (parent instanceof Tree) {
                            TreeItem[] selectedItems = ((Tree)parent).getSelection();
                            if (selectedItems.length < 1) {
                                Activator.log.warn("Impossible to find the current selection in the tree");
                                return;
                            }
                            PredefinedFragmentDescriptor predefinedFragmentDescriptor = new PredefinedFragmentDescriptor(descriptor.getId());
                            PredefinedFragmentDescriptorState state = new PredefinedFragmentDescriptorState(predefinedFragmentDescriptor, false);
                            SectionMenuCreator.this.sectionDescriptorState.addFragmentDescriptorState((IFragmentDescriptorState)state);
                        }
                    }
                };
                this.manager.appendToGroup("addGroup", (IAction)addPredefinedFragmentAction);
            }
        }
        return menu;
    }

    protected TreeItem retrieveRoot(TreeItem item) {
        if (item.getParentItem() == null) {
            return item;
        }
        return this.retrieveRoot(item.getParentItem());
    }

    protected String getNewFragmentId(EClassifier selectionClass, Stereotype stereotype, int selectionSize) {
        int i = 0;
        while (i < 100) {
            boolean found = false;
            StringBuffer buffer = new StringBuffer();
            buffer.append("fragment_");
            if (selectionSize == 1) {
                buffer.append("single");
            } else if (selectionSize < 0) {
                buffer.append("multi");
            } else {
                buffer.append(selectionSize);
            }
            buffer.append("_");
            if (selectionClass != null && selectionClass.getInstanceClass() != null) {
                buffer.append(selectionClass.getInstanceClass().getSimpleName());
            } else if (stereotype != null && stereotype.getName() != null) {
                buffer.append(stereotype.getName());
            } else {
                buffer.append("NoName");
            }
            if (i > 0) {
                buffer.append(i);
            }
            String name = buffer.toString();
            for (IFragmentDescriptorState fragmentDescriptorState : this.sectionDescriptorState.getFragmentDescriptorStates()) {
                String id = fragmentDescriptorState.getDescriptor().getId();
                if (!name.equalsIgnoreCase(id)) continue;
                found = true;
            }
            if (!found) {
                return name;
            }
            ++i;
        }
        return "";
    }
}

