/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.state;

import java.util.List;
import org.eclipse.papyrus.properties.runtime.view.constraints.AppliedStereotypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintStateUtils {
    public static boolean areCompatible(List<IConstraintDescriptor> constraintsToTest, List<ConstraintDescriptorState> referenceConstraints) {
        boolean classCompatible = ConstraintStateUtils.areClassCompatibles(ConstraintStateUtils.retrieveObjectTypeConstraint(constraintsToTest), ConstraintStateUtils.retrieveObjectTypeConstraintState(referenceConstraints));
        boolean stereotypesCompatible = ConstraintStateUtils.areStereotypesCompatibles(ConstraintStateUtils.retrieveStereotypeConstraint(constraintsToTest), ConstraintStateUtils.retrieveStereotypeConstraintState(referenceConstraints));
        return classCompatible && stereotypesCompatible;
    }

    private static boolean areStereotypesCompatibles(AppliedStereotypeConstraintDescriptor retrieveStereotypeConstraint, AppliedStereotypeConstraintDescriptor.AppliedStereotypeConstraintDescriptorState retrieveStereotypeConstraintState) {
        String referenceStereotypeName;
        String stereotypeName;
        if (retrieveStereotypeConstraint == null && retrieveStereotypeConstraintState == null) {
            return true;
        }
        if (retrieveStereotypeConstraint == null) {
            return true;
        }
        if (retrieveStereotypeConstraintState == null) {
            return false;
        }
        String string = stereotypeName = retrieveStereotypeConstraint.getStereotypeQualifiedNames().size() > 0 ? (String)retrieveStereotypeConstraint.getStereotypeQualifiedNames().get(0) : null;
        if (stereotypeName == null) {
            return false;
        }
        String string2 = referenceStereotypeName = retrieveStereotypeConstraintState.getStereotypesToApply().size() > 0 ? (String)retrieveStereotypeConstraintState.getStereotypesToApply().get(0) : null;
        if (referenceStereotypeName == null) {
            return false;
        }
        return referenceStereotypeName.equalsIgnoreCase(stereotypeName);
    }

    private static AppliedStereotypeConstraintDescriptor.AppliedStereotypeConstraintDescriptorState retrieveStereotypeConstraintState(List<ConstraintDescriptorState> referenceConstraints) {
        for (ConstraintDescriptorState descriptor : referenceConstraints) {
            if (!(descriptor instanceof AppliedStereotypeConstraintDescriptor.AppliedStereotypeConstraintDescriptorState)) continue;
            return (AppliedStereotypeConstraintDescriptor.AppliedStereotypeConstraintDescriptorState)descriptor;
        }
        return null;
    }

    private static AppliedStereotypeConstraintDescriptor retrieveStereotypeConstraint(List<IConstraintDescriptor> constraintsToTest) {
        for (IConstraintDescriptor descriptor : constraintsToTest) {
            if (!(descriptor instanceof AppliedStereotypeConstraintDescriptor)) continue;
            return (AppliedStereotypeConstraintDescriptor)descriptor;
        }
        return null;
    }

    private static boolean areClassCompatibles(Class<?> constraintClass, Class<?> referenceClass) {
        if (constraintClass == null) {
            return true;
        }
        if (referenceClass == null) {
            return false;
        }
        return constraintClass.isAssignableFrom(referenceClass);
    }

    private static Class<?> retrieveObjectTypeConstraintState(List<ConstraintDescriptorState> constraintsToTest) {
        for (ConstraintDescriptorState state : constraintsToTest) {
            if (!(state instanceof ObjectTypeConstraintDescriptor.ObjectTypeConstraintDescriptorState)) continue;
            return ((ObjectTypeConstraintDescriptor.ObjectTypeConstraintDescriptorState)state).getElementClassState();
        }
        return null;
    }

    private static Class<?> retrieveObjectTypeConstraint(List<IConstraintDescriptor> constraintsToTest) {
        for (IConstraintDescriptor state : constraintsToTest) {
            if (!(state instanceof ObjectTypeConstraintDescriptor)) continue;
            return ((ObjectTypeConstraintDescriptor)state).getElementClass();
        }
        return null;
    }
}

