/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.state;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.properties.runtime.controller.IBoundedValuesController;
import org.eclipse.papyrus.properties.runtime.state.IState;
import org.eclipse.papyrus.properties.tabbed.core.view.StatesStore;
import org.eclipse.papyrus.properties.tabbed.customization.state.StateBeanPropertyEditorController;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceStateBeanPropertyEditorController
extends StateBeanPropertyEditorController
implements IBoundedValuesController {
    public static final String ID = "referenceStateBeanPropertyEditorController";
    protected ILabelProvider labelProvider = this.initLabelProvider();

    protected ILabelProvider initLabelProvider() {
        LabelProvider provider = new LabelProvider(){

            public String getText(Object input) {
                if (input instanceof String) {
                    String propertyName = ReferenceStateBeanPropertyEditorController.this.getDescriptor().getPropertyName();
                    String stateName = ((IState)ReferenceStateBeanPropertyEditorController.this.objectToEdit.get(0)).getClass().getSimpleName();
                    try {
                        Method[] methods = StatesStore.class.getDeclaredMethods();
                        String searchMethodName = "getText" + stateName + propertyName;
                        Method[] methodArray = methods;
                        int n = methods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Method method = methodArray[n2];
                            if (searchMethodName.equalsIgnoreCase(method.getName())) {
                                method.setAccessible(true);
                                Object[] arguments = new Object[]{(String)input};
                                String text = (String)method.invoke(null, arguments);
                                if (text != null) {
                                    return text;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return "";
                }
                return input.toString();
            }

            public Image getImage(Object input) {
                if (input instanceof String) {
                    String propertyName = ReferenceStateBeanPropertyEditorController.this.getDescriptor().getPropertyName();
                    String stateName = ((IState)ReferenceStateBeanPropertyEditorController.this.objectToEdit.get(0)).getClass().getSimpleName();
                    try {
                        Method[] methods = StatesStore.class.getDeclaredMethods();
                        String searchMethodName = "getImage" + stateName + propertyName;
                        Method[] methodArray = methods;
                        int n = methods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Method method = methodArray[n2];
                            if (searchMethodName.equalsIgnoreCase(method.getName())) {
                                method.setAccessible(true);
                                Image image = (Image)method.invoke(null, new Object[0]);
                                if (image != null) {
                                    return image;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
                return null;
            }
        };
        return provider;
    }

    public ILabelProvider getEditorLabelProvider() {
        return this.labelProvider;
    }

    public Object getAvailableValues() {
        ArrayList values = new ArrayList();
        for (Object object : this.objectToEdit) {
            if (!(object instanceof IState)) continue;
            IState state = (IState)object;
            String propertyName = this.getDescriptor().getPropertyName();
            try {
                Method[] methods = state.getClass().getDeclaredMethods();
                String searchMethodName = "getAvailable" + propertyName;
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (searchMethodName.equalsIgnoreCase(method.getName())) {
                        method.setAccessible(true);
                        values.addAll((List)method.invoke((Object)state, new Object[0]));
                    }
                    ++n2;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return values;
    }

    public Object[] getCurrentValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (Object object : this.objectToEdit) {
            if (!(object instanceof IState)) continue;
            IState state = (IState)object;
            String propertyName = this.getDescriptor().getPropertyName();
            try {
                Method[] methods = state.getClass().getDeclaredMethods();
                String searchMethodName = "get" + propertyName;
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (searchMethodName.equalsIgnoreCase(method.getName())) {
                        method.setAccessible(true);
                        values.add((String)method.invoke((Object)state, new Object[0]));
                    }
                    ++n2;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return values.toArray();
    }

    public List<ViewerFilter> getViewerFilters() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        ViewerFilter typeFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        };
        filters.add(typeFilter);
        return filters;
    }

    public IStructuredContentProvider getContentProvider() {
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        };
        return contentProvider;
    }

    public ILabelProvider getBrowserLabelProvider() {
        return this.labelProvider;
    }
}

