/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.customization.state;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.papyrus.properties.runtime.view.DialogDescriptor;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.XMLParseException;
import org.eclipse.papyrus.properties.tabbed.core.view.PropertyTabViewProviderParser;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.TabDescriptorState;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatePropertyTabViewProviderParser
extends PropertyTabViewProviderParser {
    protected List<SectionSetDescriptorState> sectionSetDescriptorStates = new ArrayList<SectionSetDescriptorState>();
    protected TreeSet<TabDescriptorState> tabDescriptorStates = new TreeSet<TabDescriptorState>(new Comparator<TabDescriptorState>(){

        @Override
        public int compare(TabDescriptorState o1, TabDescriptorState o2) {
            if (o1.getAfterTab().compareTo(o2.getId()) == 0) {
                return -1;
            }
            if (o1.getId().compareTo(o2.getId()) == 0) {
                return 0;
            }
            return 1;
        }
    });

    public StatePropertyTabViewProviderParser(List<ITabDescriptor> tabDescriptors) {
        super(tabDescriptors);
    }

    public void parseXMLfile(Document document, Map<String, FragmentDescriptor> predefinedFragments, Map<String, DialogDescriptor> predefinedDialogs) throws XMLParseException {
        SectionSetDescriptorState descriptorState;
        super.parseXMLfile(document, predefinedFragments, predefinedDialogs);
        for (SectionSetDescriptor sectionSetDescriptor : this.getProvidedSectionSets()) {
            descriptorState = new SectionSetDescriptorState(sectionSetDescriptor, false);
            this.sectionSetDescriptorStates.add(descriptorState);
        }
        for (ITabDescriptor tabDescriptor : this.getProvidedTabDescriptors()) {
            descriptorState = new TabDescriptorState(tabDescriptor, false);
            this.tabDescriptorStates.add((TabDescriptorState)descriptorState);
        }
    }

    public List<SectionSetDescriptorState> getSectionSetDescriptorStates() {
        return this.sectionSetDescriptorStates;
    }

    public List<TabDescriptorState> getTabDescriptorStates() {
        return new ArrayList<TabDescriptorState>(this.tabDescriptorStates);
    }
}

