/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.table.modelelement;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.properties.modelelement.EMFModelElement;
import org.eclipse.papyrus.properties.table.provider.CustomizationContentProvider;
import org.eclipse.papyrus.properties.table.provider.CustomizationLabelProvider;
import org.eclipse.papyrus.properties.table.provider.FacetLabelProvider;
import org.eclipse.papyrus.properties.table.provider.FillingQueriesContentProvider;
import org.eclipse.papyrus.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;

public class PapyrusTableModelElement
extends EMFModelElement {
    public static final int NO_LOCALS = 0;
    public static final int ONLY_ONE_LOCALS = 1;
    public static final int ALL_LOCALS = 2;
    public static final String TABLE_CUSTOMIZATIONS = "table.customizations";
    public static final String TABLE_FACETS2 = "table.facets2";
    public static final String TABLE_FILLING_QUERIES = "fillingQueries";
    public static final String TABLE_CONTEXT = "table.context";
    private static int local_preference = 2;

    public PapyrusTableModelElement(EObject source) {
        super(source);
    }

    public PapyrusTableModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (TABLE_FILLING_QUERIES.equals(propertyPath)) {
            FeaturePath featurePath = this.getFeaturePath(TABLE_CONTEXT);
            EObject table = this.getSource(featurePath);
            Assert.isTrue((boolean)(table instanceof TableInstance));
            return new FillingQueriesContentProvider((TableInstance)table);
        }
        if (TABLE_CUSTOMIZATIONS.equals(propertyPath)) {
            FeaturePath featurePath = this.getFeaturePath(TABLE_CUSTOMIZATIONS);
            EStructuralFeature feature = this.getFeature(featurePath);
            return new CustomizationContentProvider(feature, this.getSource(featurePath), local_preference);
        }
        return super.getContentProvider(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if (TABLE_CUSTOMIZATIONS.equals(propertyPath)) {
            FeaturePath featurePath = this.getFeaturePath(TABLE_CUSTOMIZATIONS);
            EObject table = this.getSource(featurePath);
            Assert.isTrue((boolean)(table instanceof TableInstance2));
            return new CustomizationLabelProvider((TableInstance2)table, local_preference);
        }
        if (TABLE_FACETS2.equals(propertyPath)) {
            return new FacetLabelProvider();
        }
        return super.getLabelProvider(propertyPath);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        if (TABLE_FILLING_QUERIES.equals(propertyPath)) {
            return null;
        }
        return super.getValueFactory(propertyPath);
    }
}

