/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.constraints;

import org.eclipse.papyrus.properties.constraints.AbstractConstraint;
import org.eclipse.papyrus.properties.constraints.Constraint;
import org.eclipse.papyrus.properties.contexts.SimpleConstraint;
import org.eclipse.papyrus.properties.uml.util.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class HasStereotypeConstraint
extends AbstractConstraint {
    protected String stereotypeName;
    protected Element umlElement;

    public boolean match(Object selection) {
        this.umlElement = UMLUtil.resolveUMLElement(selection);
        if (this.umlElement == null) {
            return false;
        }
        Stereotype stereotype = UMLUtil.getAppliedStereotype(this.umlElement, this.stereotypeName, false);
        return stereotype != null;
    }

    public void setDescriptor(SimpleConstraint descriptor) {
        this.stereotypeName = this.getValue("stereotypeName");
    }

    public boolean overrides(Constraint constraint) {
        boolean overrides = false;
        if (constraint instanceof HasStereotypeConstraint) {
            HasStereotypeConstraint stereotypeConstraint = (HasStereotypeConstraint)constraint;
            if (!this.stereotypeName.equals(stereotypeConstraint.stereotypeName)) {
                Stereotype thisStereotype = this.umlElement.getApplicableStereotype(this.stereotypeName);
                Stereotype otherStereotype = UMLUtil.findStereotype(this.umlElement, stereotypeConstraint.stereotypeName);
                if (UMLUtil.getAllSuperStereotypes(thisStereotype).contains(otherStereotype)) {
                    overrides = true;
                }
            }
        }
        return overrides || super.overrides(constraint);
    }

    public String toString() {
        return "HasStereotype " + this.stereotypeName + " (" + (this.getView().getElementMultiplicity() == 1 ? "Single" : "Multiple") + ")";
    }

    protected boolean equivalent(Constraint constraint) {
        if (this == constraint) {
            return true;
        }
        if (constraint == null) {
            return false;
        }
        if (!(constraint instanceof HasStereotypeConstraint)) {
            return false;
        }
        HasStereotypeConstraint other = (HasStereotypeConstraint)constraint;
        return !(this.stereotypeName == null ? other.stereotypeName != null : !this.stereotypeName.equals(other.stereotypeName));
    }
}

