/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.constraints;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.papyrus.properties.constraints.AbstractConstraint;
import org.eclipse.papyrus.properties.constraints.Constraint;
import org.eclipse.papyrus.properties.contexts.ConstraintDescriptor;
import org.eclipse.papyrus.properties.uml.datatype.DataTypeObservableValue;
import org.eclipse.papyrus.properties.util.ClassLoader;

public class IsDataTypeConstraint
extends AbstractConstraint {
    public static final String DATATYPE_PROPERTY = "datatype";
    private EDataType dataType;

    protected void setDescriptor(ConstraintDescriptor descriptor) {
        String dataTypeClassName = this.getValue(DATATYPE_PROPERTY);
        ClassLoader loader = new ClassLoader();
        this.dataType = (EDataType)loader.newInstance(dataTypeClassName, EDataType.class);
    }

    public boolean match(Object selection) {
        if (this.dataType == null) {
            return false;
        }
        if (selection instanceof DataTypeObservableValue) {
            DataTypeObservableValue observer = (DataTypeObservableValue)selection;
            return observer.getValueType() == this.dataType;
        }
        return false;
    }

    protected boolean equivalent(Constraint constraint) {
        if (constraint == null) {
            return false;
        }
        if (constraint instanceof IsDataTypeConstraint) {
            return ((IsDataTypeConstraint)constraint).dataType == this.dataType;
        }
        return false;
    }
}

