/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.constraints;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.properties.constraints.AbstractConstraint;
import org.eclipse.papyrus.properties.constraints.Constraint;
import org.eclipse.papyrus.properties.contexts.SimpleConstraint;
import org.eclipse.papyrus.properties.uml.util.UMLUtil;
import org.eclipse.papyrus.properties.util.EMFHelper;
import org.eclipse.uml2.uml.Element;

public class UmlInstanceOfConstraint
extends AbstractConstraint {
    private String umlClassName;

    public void setDescriptor(SimpleConstraint descriptor) {
        this.umlClassName = this.getValue("umlClassName");
    }

    public boolean match(Object selection) {
        Element umlSemantic = UMLUtil.resolveUMLElement(selection);
        if (umlSemantic != null) {
            return EMFHelper.isInstance((EObject)umlSemantic, (String)this.umlClassName, (EPackage)UMLUtil.getUMLMetamodel());
        }
        return false;
    }

    public boolean overrides(Constraint constraint) {
        boolean result;
        if (!(constraint instanceof UmlInstanceOfConstraint)) {
            return false;
        }
        UmlInstanceOfConstraint umlConstraint = (UmlInstanceOfConstraint)constraint;
        boolean bl = result = !this.umlClassName.equals(umlConstraint.umlClassName) && UMLUtil.isSubClass(this.umlClassName, umlConstraint.umlClassName);
        return result || super.overrides(constraint);
    }

    public String toString() {
        return "UMLInstanceOf " + this.umlClassName + " (" + (this.getView().getElementMultiplicity() == 1 ? "Single" : "Multiple") + ")";
    }

    protected boolean equivalent(Constraint constraint) {
        if (this == constraint) {
            return true;
        }
        if (constraint == null) {
            return false;
        }
        if (!(constraint instanceof UmlInstanceOfConstraint)) {
            return false;
        }
        UmlInstanceOfConstraint other = (UmlInstanceOfConstraint)constraint;
        return !(this.umlClassName == null ? other.umlClassName != null : !this.umlClassName.equals(other.umlClassName));
    }

    public String getClassName() {
        return this.umlClassName;
    }
}

