/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.databinding;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.properties.uml.Activator;
import org.eclipse.papyrus.properties.uml.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.widgets.databinding.AggregatedObservable;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class OwnerObservableValue
extends AbstractObservableValue
implements IChangeListener,
AggregatedObservable,
CommandBasedObservableValue {
    private Property memberEnd;
    private EditingDomain domain;
    private String currentValue;
    private final IObservableList navigableEndsObservableList;
    public static String CLASSIFIER = "Classifier";
    public static String ASSOCIATION = "Association";

    public OwnerObservableValue(EObject source, EditingDomain domain) {
        this.memberEnd = (Property)source;
        this.domain = domain;
        this.navigableEndsObservableList = EMFProperties.list((EStructuralFeature)UMLPackage.eINSTANCE.getAssociation_NavigableOwnedEnd()).observe((Object)this.memberEnd.getAssociation());
        this.navigableEndsObservableList.addChangeListener((IChangeListener)this);
    }

    public void handleChange(ChangeEvent event) {
        this.fireValueChange(Diffs.createValueDiff((Object)this.currentValue, (Object)this.doGetValue()));
    }

    public Object getValueType() {
        return String.class;
    }

    protected String doGetValue() {
        return this.memberEnd.getAssociation().getOwnedEnds().contains((Object)this.memberEnd) ? "Association" : "Classifier";
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    public void dispose() {
        super.dispose();
        this.navigableEndsObservableList.removeChangeListener((IChangeListener)this);
        this.navigableEndsObservableList.dispose();
    }

    public Command getCommand(Object value) {
        if (value instanceof String) {
            String owner = (String)value;
            boolean isOwnedByAssociation = ASSOCIATION.equals(owner);
            Association association = this.memberEnd.getAssociation();
            if (association.getMemberEnds().size() > 2) {
                Activator.log.warn("Cannot change End owner for n-ary associations");
                return UnexecutableCommand.INSTANCE;
            }
            GMFtoEMFCommandWrapper command = null;
            if (isOwnedByAssociation) {
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)association);
                if (provider != null) {
                    EReference feature = UMLPackage.eINSTANCE.getAssociation_OwnedEnd();
                    ArrayList<Property> attributeList = new ArrayList<Property>();
                    attributeList.addAll((Collection<Property>)association.getOwnedEnds());
                    attributeList.add(this.memberEnd);
                    SetRequest request = new SetRequest((EObject)association, (EStructuralFeature)feature, attributeList);
                    ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
                    command = new GMFtoEMFCommandWrapper(createGMFCommand);
                }
            } else {
                EList ownerList = association.getEndTypes();
                Type ownerType = ((Type)ownerList.get(0)).equals(this.memberEnd.getType()) && ownerList.size() > 1 ? (Type)ownerList.get(1) : (Type)ownerList.get(0);
                EStructuralFeature ownedAttributeFeature = this.getFeatureForType(ownerType);
                if (ownedAttributeFeature != null) {
                    ArrayList<Property> attributeList = new ArrayList<Property>();
                    attributeList.addAll((Collection<Property>)((EList)ownerType.eGet(ownedAttributeFeature)));
                    attributeList.add(this.memberEnd);
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)ownerType);
                    if (provider != null) {
                        SetRequest request = new SetRequest((EObject)ownerType, ownedAttributeFeature, (Object)this.memberEnd);
                        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
                        command = new GMFtoEMFCommandWrapper(createGMFCommand);
                    }
                }
            }
            if (command != null) {
                this.currentValue = owner;
            } else {
                Activator.log.warn("Cannot modify the memberEnd owner");
            }
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private EStructuralFeature getFeatureForType(Type type) {
        if (type instanceof StructuredClassifier) {
            return UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute();
        }
        if (type instanceof Interface) {
            return UMLPackage.eINSTANCE.getInterface_OwnedAttribute();
        }
        if (type instanceof DataType) {
            return UMLPackage.eINSTANCE.getDataType_OwnedAttribute();
        }
        if (type instanceof Artifact) {
            return UMLPackage.eINSTANCE.getArtifact_OwnedAttribute();
        }
        if (type instanceof Signal) {
            return UMLPackage.eINSTANCE.getSignal_OwnedAttribute();
        }
        Activator.log.warn("Unknown type : " + type.eClass().getName());
        EStructuralFeature feature = type.eClass().getEStructuralFeature("ownedAttribute");
        if (feature == null) {
            Activator.log.warn("Cannot find a valid feature for type " + type.eClass().getName());
        }
        return feature;
    }

    public AggregatedObservable aggregate(IObservable observable) {
        try {
            return new AggregatedPapyrusObservableValue(this.domain, this, observable);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public boolean hasDifferentValues() {
        return false;
    }
}

