/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.databinding;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.properties.databinding.EMFObservableList;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusObservableList
extends EMFObservableList {
    public PapyrusObservableList(List<?> wrappedList, EditingDomain domain, EObject source, EStructuralFeature feature) {
        super(wrappedList, domain, source, feature);
    }

    protected IElementEditService getProvider() {
        return ElementEditServiceUtils.getCommandProvider((Object)this.source);
    }

    protected Command getCommandFromRequest(IElementEditService provider, IEditCommandRequest request) {
        ICommand createGMFCommand = provider.getEditCommand(request);
        return new GMFtoEMFCommandWrapper(createGMFCommand);
    }

    protected Command getAddCommand(int index, Object value) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            values.add(index, value);
            SetRequest request = new SetRequest(this.source, this.feature, values);
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return super.getAddCommand(index, value);
    }

    protected Command getAddCommand(Object value) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            values.add(value);
            SetRequest request = new SetRequest(this.source, this.feature, values);
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return super.getAddCommand(value);
    }

    protected Command getAddAllCommand(Collection<?> values) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList result = new LinkedList((Collection<?>)((Object)this));
            result.addAll(values);
            SetRequest request = new SetRequest(this.source, this.feature, values);
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return super.getAddAllCommand(values);
    }

    protected Command getAddAllCommand(int index, Collection<?> values) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList result = new LinkedList((Collection<?>)((Object)this));
            result.addAll(index, values);
            SetRequest request = new SetRequest(this.source, this.feature, values);
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return super.getAddAllCommand(index, values);
    }

    protected Command getClearCommand() {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            SetRequest request = new SetRequest(this.source, this.feature, (Object)Collections.EMPTY_LIST);
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return super.getClearCommand();
    }

    protected Command getRemoveCommand(int index) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList values = new LinkedList(this);
            values.remove(index);
            SetRequest request = new SetRequest(this.source, this.feature, values);
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return null;
    }

    protected Command getRemoveCommand(Object value) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            DestroyElementRequest request;
            if (this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
                request = new DestroyElementRequest((EObject)value, false);
            } else {
                LinkedList values = new LinkedList(this);
                values.remove(value);
                request = new SetRequest(this.source, this.feature, values);
            }
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return super.getRemoveCommand(value);
    }

    protected Command getRemoveAllCommand(Collection<?> values) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList result = new LinkedList(this);
            values.removeAll(values);
            SetRequest request = new SetRequest(this.source, this.feature, result);
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return super.getRemoveAllCommand(values);
    }

    protected List<Command> getMoveCommands(int oldIndex, int newIndex) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList values = new LinkedList(this);
            Object result = values.remove(oldIndex);
            values.add(newIndex, result);
            SetRequest request = new SetRequest(this.source, this.feature, values);
            return Collections.singletonList(this.getCommandFromRequest(provider, (IEditCommandRequest)request));
        }
        return super.getMoveCommands(oldIndex, newIndex);
    }

    protected Command getSetCommand(int index, Object value) {
        IElementEditService provider = this.getProvider();
        if (provider != null) {
            LinkedList<Object> values = new LinkedList<Object>((Collection<Object>)((Object)this));
            values.set(index, value);
            SetRequest request = new SetRequest(this.source, this.feature, values);
            return this.getCommandFromRequest(provider, (IEditCommandRequest)request);
        }
        return super.getSetCommand(index, value);
    }
}

