/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.databinding;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.properties.Activator;
import org.eclipse.papyrus.properties.databinding.EMFObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.properties.util.EMFHelper;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.widgets.databinding.AggregatedObservable;

public class PapyrusObservableValue
extends EMFObservableValue
implements AggregatedObservable,
CommandBasedObservableValue {
    public PapyrusObservableValue(EObject eObject, EStructuralFeature eStructuralFeature, EditingDomain domain) {
        this(Realm.getDefault(), eObject, eStructuralFeature, domain);
    }

    public PapyrusObservableValue(Realm realm, EObject eObject, EStructuralFeature eStructuralFeature, EditingDomain domain) {
        super(eObject, eStructuralFeature, domain);
    }

    protected void doSetValue(Object value) {
        Command emfCommand = this.getCommand(value);
        this.domain.getCommandStack().execute(emfCommand);
    }

    public Command getCommand(Object value) {
        EObject eObjectValue = EMFHelper.getEObject((Object)value);
        if (eObjectValue != null) {
            value = eObjectValue;
        }
        try {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getObserved());
            if (provider != null) {
                SetRequest request = new SetRequest((TransactionalEditingDomain)this.domain, this.eObject, this.eStructuralFeature, value);
                ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
                GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
                return emfCommand;
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public AggregatedObservable aggregate(IObservable observable) {
        try {
            return new AggregatedPapyrusObservableValue(this.domain, this, observable);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public boolean hasDifferentValues() {
        return false;
    }
}

