/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.databinding;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.properties.Activator;
import org.eclipse.papyrus.umlutils.MessageUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Signal;

public class SignatureObservableValue
extends AbstractObservableValue {
    private Message source;
    private TransactionalEditingDomain domain;

    public SignatureObservableValue(EObject source, EditingDomain domain) {
        if (!(source instanceof Message)) {
            throw new IllegalArgumentException("The source EObject must be a Message");
        }
        if (!(domain instanceof TransactionalEditingDomain)) {
            throw new IllegalArgumentException("The EditingDomain must be a TransactionalEditingDomain");
        }
        this.source = (Message)source;
        this.domain = (TransactionalEditingDomain)domain;
    }

    public Object getValueType() {
        return EObject.class;
    }

    protected Object doGetValue() {
        return this.source.getSignature();
    }

    protected void doSetValue(Object value) {
        try {
            if (value instanceof Operation) {
                Operation operation = (Operation)value;
                MessageUtil.setMessageSignature((Message)this.source, (Operation)operation, (TransactionalEditingDomain)this.domain);
            } else if (value instanceof Signal) {
                Signal signal = (Signal)value;
                MessageUtil.setMessageSignature((Message)this.source, (Signal)signal, (TransactionalEditingDomain)this.domain);
            } else if (value == null) {
                Object currentValue = this.doGetValue();
                if (currentValue instanceof Operation) {
                    MessageUtil.setMessageSignature((Message)this.source, null, (TransactionalEditingDomain)this.domain);
                } else if (currentValue instanceof Signal) {
                    MessageUtil.setMessageSignature((Message)this.source, null, (TransactionalEditingDomain)this.domain);
                }
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }
}

