/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.databinding;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.properties.uml.databinding.AbstractStereotypeListener;
import org.eclipse.papyrus.properties.uml.databinding.command.ApplyStereotypeCommand;
import org.eclipse.papyrus.properties.uml.databinding.command.UnapplyStereotypeCommand;
import org.eclipse.papyrus.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.widgets.editors.ICommitListener;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeApplicationObservableList
extends WritableList
implements ICommitListener {
    private Element umlSource;
    private EditingDomain domain;
    private final List<Command> commands;
    private AbstractStereotypeListener listener;

    public StereotypeApplicationObservableList(Element umlSource, EditingDomain domain) {
        super(new LinkedList(umlSource.getAppliedStereotypes()), Stereotype.class);
        this.umlSource = umlSource;
        this.domain = domain;
        this.commands = new LinkedList<Command>();
        this.listener = new AbstractStereotypeListener(umlSource){

            protected void handleUnappliedStereotype(final EObject newValue) {
                StereotypeApplicationObservableList.this.fireListChange(new ListDiff(){

                    public ListDiffEntry[] getDifferences() {
                        return new ListDiffEntry[]{new ListDiffEntry(){

                            public int getPosition() {
                                return 0;
                            }

                            public boolean isAddition() {
                                return false;
                            }

                            public Object getElement() {
                                return newValue;
                            }
                        }};
                    }
                });
            }

            protected void handleAppliedStereotype(final EObject newValue) {
                StereotypeApplicationObservableList.this.fireListChange(new ListDiff(){

                    public ListDiffEntry[] getDifferences() {
                        return new ListDiffEntry[]{new ListDiffEntry(){

                            public int getPosition() {
                                return 0;
                            }

                            public boolean isAddition() {
                                return true;
                            }

                            public Object getElement() {
                                return newValue;
                            }
                        }};
                    }
                });
            }
        };
    }

    public void commit(AbstractEditor editor) {
        if (this.commands.isEmpty()) {
            return;
        }
        CompoundCommand compoundCommand = new CompoundCommand(){

            public void execute() {
                super.execute();
                StereotypeApplicationObservableList.this.refreshCacheList();
            }

            public void undo() {
                super.undo();
                StereotypeApplicationObservableList.this.refreshCacheList();
            }

            public void redo() {
                super.redo();
                StereotypeApplicationObservableList.this.refreshCacheList();
            }

            public boolean canExecute() {
                return this.commandList.isEmpty() ? false : ((Command)this.commandList.get(0)).canExecute();
            }
        };
        for (Command cmd : this.commands) {
            compoundCommand.append(cmd);
        }
        this.domain.getCommandStack().execute((Command)compoundCommand);
        this.commands.clear();
    }

    private void refreshCacheList() {
        this.wrappedList.clear();
        this.wrappedList.addAll(this.umlSource.getAppliedStereotypes());
        this.fireListChange(null);
    }

    public void clear() {
        this.removeAll(new LinkedList(this.wrappedList));
    }

    public boolean add(Object o) {
        if (!(o instanceof Stereotype)) {
            return false;
        }
        Stereotype stereotype = (Stereotype)o;
        ApplyStereotypeCommand command = new ApplyStereotypeCommand(this.umlSource, stereotype);
        this.commands.add((Command)command);
        return this.wrappedList.add(o);
    }

    public boolean remove(Object o) {
        if (!(o instanceof Stereotype)) {
            return false;
        }
        Stereotype stereotype = (Stereotype)o;
        UnapplyStereotypeCommand command = new UnapplyStereotypeCommand(this.umlSource, stereotype);
        this.commands.add((Command)command);
        return this.wrappedList.remove(o);
    }

    public boolean addAll(Collection c) {
        c.removeAll(this.wrappedList);
        ApplyStereotypeCommand command = new ApplyStereotypeCommand(this.umlSource, c);
        this.commands.add((Command)command);
        return this.wrappedList.addAll(c);
    }

    public boolean removeAll(Collection c) {
        UnapplyStereotypeCommand command = new UnapplyStereotypeCommand(this.umlSource, c);
        this.commands.add((Command)command);
        return this.wrappedList.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        LinkedList objectsToRemove = new LinkedList();
        for (Object object : c) {
            if (this.contains(object)) continue;
            objectsToRemove.add(object);
        }
        return this.removeAll(objectsToRemove);
    }

    public void add(int index, Object value) {
        this.add(value);
    }

    public boolean addAll(int index, Collection c) {
        return this.addAll(c);
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        super.dispose();
        this.listener.dispose();
    }
}

