/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.databinding.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnapplyStereotypeCommand
extends AbstractCommand {
    private Element element;
    private Collection<Stereotype> stereotypes;

    public UnapplyStereotypeCommand(Element element, Collection<Stereotype> stereotypes) {
        this.element = element;
        this.stereotypes = stereotypes;
    }

    public UnapplyStereotypeCommand(Element element, Stereotype stereotype) {
        this.element = element;
        this.stereotypes = Collections.singletonList(stereotype);
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        for (Stereotype stereotype : this.stereotypes) {
            this.element.unapplyStereotype(stereotype);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        for (Stereotype stereotype : this.stereotypes) {
            this.element.applyStereotype(stereotype);
        }
    }

    public void redo() {
        this.execute();
    }
}

