/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.datatype;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.papyrus.properties.uml.datatype.DataTypeObservableValue;
import org.eclipse.papyrus.properties.util.ClassLoader;

public class DataTypeProvider {
    private final Map<String, Class<? extends DataTypeObservableValue>> observableDataTypes = new HashMap<String, Class<? extends DataTypeObservableValue>>();
    public static final String EXTENSION_ID = "org.eclipse.papyrus.properties.uml.datatype";
    public static DataTypeProvider instance = new DataTypeProvider();

    private DataTypeProvider() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String dataTypeName = e.getAttribute("dataType");
            ClassLoader loader = new ClassLoader();
            String observableClassName = e.getAttribute("observable");
            Class observableClass = loader.loadClass(observableClassName, DataTypeObservableValue.class);
            if (observableClass != null) {
                this.observableDataTypes.put(dataTypeName, observableClass);
            }
            ++n2;
        }
    }

    public DataTypeObservableValue getObservableDataType(EDataType dataType) {
        ClassLoader loader = new ClassLoader();
        for (String key : this.observableDataTypes.keySet()) {
            if (!key.equals(dataType.getName())) continue;
            return (DataTypeObservableValue)loader.newInstance(this.observableDataTypes.get(key));
        }
        return null;
    }

    public boolean canHandle(EDataType eType) {
        return this.observableDataTypes.containsKey(eType.getName());
    }
}

