/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.expression;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.papyrus.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.widgets.editors.ICommitListener;

public class ExpressionList
extends WritableList
implements IChangeListener,
ICommitListener {
    private List<Expression> expressions = this.wrappedList;
    private IObservableList languages;
    private IObservableList bodies;
    private boolean ignoreChanges = false;

    public ExpressionList(IObservableList languages, IObservableList bodies) {
        super(new LinkedList(), Expression.class);
        this.languages = languages;
        this.bodies = bodies;
        languages.addChangeListener((IChangeListener)this);
        bodies.addChangeListener((IChangeListener)this);
        this.UMLToExpression();
    }

    private void UMLToExpression() {
        this.expressions.clear();
        int maxSize = Math.max(this.languages.size(), this.bodies.size());
        Iterator languageIterator = this.languages.iterator();
        Iterator bodyIterator = this.bodies.iterator();
        int i = 0;
        while (i < maxSize) {
            Expression expression = new Expression();
            if (languageIterator.hasNext()) {
                expression.language = (String)languageIterator.next();
            }
            if (bodyIterator.hasNext()) {
                expression.body = (String)bodyIterator.next();
            }
            this.expressions.add(expression);
            ++i;
        }
    }

    public void handleChange(ChangeEvent event) {
        if (!this.ignoreChanges) {
            this.UMLToExpression();
        }
    }

    public void commit(AbstractEditor editor) {
        this.ignoreChanges = true;
        this.expressionToUML();
        if (this.languages instanceof ICommitListener) {
            ((ICommitListener)this.languages).commit(editor);
        }
        if (this.bodies instanceof ICommitListener) {
            ((ICommitListener)this.bodies).commit(editor);
        }
        this.ignoreChanges = false;
    }

    void expressionToUML() {
        int fillLanguage = 0;
        int fillBody = 0;
        this.languages.clear();
        this.bodies.clear();
        Iterator<Expression> iterator = this.expressions.iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            if (expression == null) {
                iterator.remove();
                continue;
            }
            String language = expression.getLanguage();
            String body = expression.getBody();
            if (language == null && body == null) {
                iterator.remove();
                continue;
            }
            if (language != null && body != null) {
                this.addLanguage(language, fillLanguage);
                this.addBody(body, fillBody);
                fillLanguage = 0;
                fillBody = 0;
            }
            if (language == null) {
                ++fillLanguage;
                this.addBody(body, fillBody);
                fillBody = 0;
                continue;
            }
            if (body != null) continue;
            ++fillBody;
            this.addLanguage(language, fillLanguage);
            fillLanguage = 0;
        }
    }

    private void addBody(String body, int fillBody) {
        int i = 0;
        while (i < fillBody) {
            this.bodies.add((Object)"");
            ++i;
        }
        this.bodies.add((Object)body);
    }

    private void addLanguage(String language, int fillLanguage) {
        int i = 0;
        while (i < fillLanguage) {
            this.languages.add((Object)"");
            ++i;
        }
        this.languages.add((Object)language);
    }

    public static class Expression {
        String language;
        String body;

        public String getLanguage() {
            return this.language;
        }

        public String getBody() {
            return this.body;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String toString() {
            return this.language;
        }

        public int hashCode() {
            return this.language == null ? 0 : this.language.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Expression)) {
                return false;
            }
            Expression otherExpression = (Expression)other;
            if (otherExpression.getLanguage() == null) {
                return this.getLanguage() == null;
            }
            return otherExpression.getLanguage().equals(this.getLanguage());
        }
    }
}

