/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.properties.modelelement.AbstractModelElement;
import org.eclipse.papyrus.properties.uml.Activator;
import org.eclipse.papyrus.properties.uml.databinding.ImageExpressionObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.ImageKindObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.ImageNameObservableValue;
import org.eclipse.papyrus.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.uml2.uml.Image;

public class CustomImageModelElement
extends AbstractModelElement {
    protected Image image;
    protected EditingDomain editingDomain;
    public static final String KIND = "kind";
    public static final String EXPRESSION = "expression";
    public static final String NAME = "name";

    public CustomImageModelElement(Image umlSource, EditingDomain domain) {
        this.image = umlSource;
        this.editingDomain = domain;
    }

    protected IObservable doGetObservable(String propertyPath) {
        if (propertyPath.equals(KIND)) {
            return new ImageKindObservableValue(this.image, this.editingDomain);
        }
        if (propertyPath.equals(EXPRESSION)) {
            return new ImageExpressionObservableValue(this.image, this.editingDomain);
        }
        if (propertyPath.equals(NAME)) {
            return new ImageNameObservableValue(this.image, this.editingDomain);
        }
        Activator.log.warn("Unknown property : " + propertyPath);
        return null;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals(KIND)) {
            return new AbstractStaticContentProvider(){

                public Object[] getElements() {
                    return new String[]{"undefined", "icon", "shape"};
                }
            };
        }
        return EmptyContentProvider.instance;
    }
}

