/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.modelelement;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.properties.Activator;
import org.eclipse.papyrus.properties.contexts.DataContextElement;
import org.eclipse.papyrus.properties.modelelement.ModelElement;
import org.eclipse.papyrus.properties.modelelement.ModelElementFactory;
import org.eclipse.papyrus.properties.uml.modelelement.CustomImageModelElement;
import org.eclipse.papyrus.properties.uml.util.UMLUtil;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;

public class CustomImageModelElementFactory
implements ModelElementFactory {
    public ModelElement createFromSource(Object sourceElement, DataContextElement context) {
        Element umlSource = UMLUtil.resolveUMLElement(sourceElement);
        if (umlSource == null) {
            Activator.log.warn("Unable to resolve the selected element to a UML Element");
            return null;
        }
        if (umlSource instanceof Image) {
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)umlSource);
            if (domain == null) {
                ServicesRegistry registry = EditorUtils.getServiceRegistry();
                ModelSet modelSet = ModelUtils.getModelSet((ServicesRegistry)registry);
                domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)((Resource)modelSet.getResources().get(0)).getContents().get(0)));
            }
            return new CustomImageModelElement((Image)umlSource, domain);
        }
        Activator.log.warn("The selected element is not a UML Image");
        return null;
    }
}

