/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.properties.modelelement.AbstractModelElement;
import org.eclipse.papyrus.properties.uml.Activator;
import org.eclipse.papyrus.properties.uml.databinding.ExtensionEndMultiplicityObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.MultiplicityObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.NavigationObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.OwnerObservableValue;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.widgets.providers.StaticContentProvider;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class MemberEndModelElement
extends AbstractModelElement {
    private EObject source;
    private EditingDomain domain;
    public static String MULTIPLICITY = "multiplicity";
    public static String OWNER = "owner";
    public static String NAVIGABLE = "navigable";

    public MemberEndModelElement(EObject source, EditingDomain domain) {
        this.source = source;
        this.domain = domain;
    }

    public IObservable doGetObservable(String propertyPath) {
        if (propertyPath.equals(MULTIPLICITY)) {
            if (this.source instanceof ExtensionEnd) {
                return new ExtensionEndMultiplicityObservableValue((ExtensionEnd)this.source, this.domain);
            }
            return new MultiplicityObservableValue(this.source, this.domain);
        }
        if (propertyPath.equals(OWNER)) {
            return new OwnerObservableValue(this.source, this.domain);
        }
        if (propertyPath.equals(NAVIGABLE)) {
            return new NavigationObservableValue(this.source, this.domain);
        }
        Activator.log.warn("The property " + propertyPath + " doesn't exist");
        return null;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals(MULTIPLICITY)) {
            if (this.source instanceof ExtensionEnd) {
                return new StaticContentProvider((Object[])new String[]{MultiplicityObservableValue.ONE, MultiplicityObservableValue.OPTIONAL});
            }
            return new StaticContentProvider((Object[])new String[]{MultiplicityObservableValue.ANY, MultiplicityObservableValue.ONE_OR_MORE, MultiplicityObservableValue.OPTIONAL, MultiplicityObservableValue.ONE});
        }
        if (propertyPath.equals(OWNER)) {
            return new StaticContentProvider((Object[])new String[]{OwnerObservableValue.ASSOCIATION, OwnerObservableValue.CLASSIFIER});
        }
        return super.getContentProvider(propertyPath);
    }

    public boolean isMandatory(String propertyPath) {
        return true;
    }

    public boolean isEditable(String propertyPath) {
        if (propertyPath.equals(OWNER)) {
            EList memberEnds = ((Property)this.source).getAssociation().getMemberEnds();
            if (memberEnds.size() == 2 && this.isAssociation((Property)memberEnds.get(0)) && this.isAssociation((Property)memberEnds.get(1))) {
                return false;
            }
            return ((Property)this.source).getAssociation().getMemberEnds().size() <= 2;
        }
        return true;
    }

    private boolean isAssociation(Property property) {
        return property.getType().eClass() == UMLPackage.eINSTANCE.getAssociation();
    }

    public boolean forceRefresh(String propertyPath) {
        return propertyPath.equals(NAVIGABLE) || propertyPath.equals(OWNER);
    }
}

