/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.modelelement;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.properties.modelelement.EMFModelElement;
import org.eclipse.papyrus.properties.uml.databinding.PapyrusObservableList;
import org.eclipse.papyrus.properties.uml.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.properties.uml.datatype.DataTypeProvider;
import org.eclipse.papyrus.properties.uml.datatype.StructuredDataTypeObservableValue;
import org.eclipse.papyrus.properties.uml.providers.UMLLabelProvider;
import org.eclipse.papyrus.properties.util.EMFHelper;
import org.eclipse.papyrus.uml.modelexplorer.widgets.ServiceEditFilteredUMLContentProvider;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.papyrus.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeModelElement
extends EMFModelElement {
    public StereotypeModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    public IObservable doGetObservable(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(featurePath);
        if (feature.getEType() instanceof EDataType && !(feature.getEType() instanceof EEnum) && feature.getUpperBound() == 1 && DataTypeProvider.instance.canHandle((EDataType)feature.getEType())) {
            return new StructuredDataTypeObservableValue(this.source, feature, this.domain, (EDataType)feature.getEType());
        }
        if (feature.getUpperBound() != 1) {
            return new PapyrusObservableList((List<?>)EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source), this.domain, this.getSource(featurePath), feature);
        }
        return new PapyrusObservableValue(this.getSource(featurePath), feature, this.domain);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature.getEType() instanceof EEnum) {
            return super.getLabelProvider(propertyPath);
        }
        return new UMLLabelProvider();
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(featurePath);
        EClassifier type = feature.getEType();
        if (this.isStereotype(type)) {
            return this.getStereotypedReferenceContentProvider(propertyPath);
        }
        if (type instanceof EEnum || type instanceof EClass) {
            return super.getContentProvider(propertyPath);
        }
        return EmptyContentProvider.instance;
    }

    protected boolean isStereotype(EClassifier type) {
        if (type instanceof Stereotype) {
            return true;
        }
        if (type instanceof EClass) {
            EClass eClass = (EClass)type;
            return !EMFHelper.isSubclass((EClass)eClass, (EClass)UMLPackage.eINSTANCE.getElement());
        }
        return false;
    }

    protected IStaticContentProvider getStereotypedReferenceContentProvider(String propertyPath) {
        Element umlElement;
        EStructuralFeature feature = this.getFeature(propertyPath);
        Package root = null;
        if (this.source != null && (umlElement = UMLUtil.getBaseElement((EObject)this.source)) != null && umlElement.getNearestPackage() != null) {
            root = PackageUtil.getRootPackage((Element)umlElement);
        }
        ServiceEditFilteredUMLContentProvider contentProvider = new ServiceEditFilteredUMLContentProvider(this.source, feature, root);
        contentProvider.setMetaClassWanted((Object)feature.getEType());
        contentProvider.setMetaClassNotWanted(Collections.EMPTY_LIST);
        return contentProvider;
    }
}

