/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.modelelement;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.properties.contexts.DataContextElement;
import org.eclipse.papyrus.properties.modelelement.ModelElement;
import org.eclipse.papyrus.properties.modelelement.ModelElementFactory;
import org.eclipse.papyrus.properties.uml.Activator;
import org.eclipse.papyrus.properties.uml.modelelement.StereotypeModelElement;
import org.eclipse.papyrus.properties.uml.util.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeModelElementFactory
implements ModelElementFactory {
    public ModelElement createFromSource(Object source, DataContextElement context) {
        if (source instanceof IAdaptable) {
            Stereotype stereotype;
            IAdaptable adaptable = (IAdaptable)source;
            Element umlElement = (Element)adaptable.getAdapter(EObject.class);
            EObject stereotypeApplication = umlElement.getStereotypeApplication(stereotype = UMLUtil.getAppliedStereotype(umlElement, this.getQualifiedName(context), false));
            if (stereotypeApplication == null) {
                Activator.log.warn("Stereotype " + this.getQualifiedName(context) + " is not applied on " + umlElement);
            } else {
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)stereotypeApplication);
                return new StereotypeModelElement(stereotypeApplication, domain);
            }
        }
        return null;
    }

    protected String getQualifiedName(DataContextElement context) {
        if (context.getPackage() == null) {
            return context.getName();
        }
        return String.valueOf(this.getQualifiedName((DataContextElement)context.getPackage())) + "::" + context.getName();
    }
}

