/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.modelelement;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.properties.modelelement.EMFModelElement;
import org.eclipse.papyrus.properties.providers.ContainerContentProvider;
import org.eclipse.papyrus.properties.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.properties.providers.EMFObjectLabelProvider;
import org.eclipse.papyrus.properties.providers.FeatureContentProvider;
import org.eclipse.papyrus.properties.uml.creation.ConnectorTypeEditorFactory;
import org.eclipse.papyrus.properties.uml.creation.MessageValueSpecificationFactory;
import org.eclipse.papyrus.properties.uml.creation.OwnedRuleCreationFactory;
import org.eclipse.papyrus.properties.uml.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.properties.uml.databinding.ExtensionRequiredObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.PapyrusObservableList;
import org.eclipse.papyrus.properties.uml.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.properties.uml.databinding.ProvidedInterfaceObservableList;
import org.eclipse.papyrus.properties.uml.databinding.RequiredInterfaceObservableList;
import org.eclipse.papyrus.properties.uml.databinding.SignatureObservableValue;
import org.eclipse.papyrus.properties.uml.providers.InstanceValueContentProvider;
import org.eclipse.papyrus.properties.uml.providers.SignatureContentProvider;
import org.eclipse.papyrus.properties.uml.providers.UMLLabelProvider;
import org.eclipse.papyrus.uml.modelexplorer.widgets.ServiceEditFilteredUMLContentProvider;
import org.eclipse.papyrus.uml.modelexplorer.widgets.UMLElementMEBContentProvider;
import org.eclipse.papyrus.uml.modelexplorer.widgets.util.HistoryUtil;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.papyrus.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLModelElement
extends EMFModelElement {
    public static final Set<EStructuralFeature> ownedRuleSubsets = new HashSet<EStructuralFeature>();

    static {
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getBehavior_Precondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getBehavior_Postcondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getOperation_BodyCondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getOperation_Precondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getOperation_Postcondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getProtocolTransition_PreCondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getProtocolTransition_PostCondition());
        ownedRuleSubsets.add((EStructuralFeature)UMLPackage.eINSTANCE.getTransition_Guard());
    }

    public UMLModelElement(EObject source) {
        super(source);
    }

    public UMLModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    public IObservable doGetObservable(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getMessage_Signature()) {
            return new SignatureObservableValue(this.source, this.domain);
        }
        if (feature == UMLPackage.eINSTANCE.getExtension_IsRequired()) {
            return new ExtensionRequiredObservableValue((Extension)this.source, this.domain);
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Provided()) {
            return new ProvidedInterfaceObservableList((Port)this.source, this.domain);
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Required()) {
            return new RequiredInterfaceObservableList((Port)this.source, this.domain);
        }
        if (feature == null) {
            return null;
        }
        if (feature.getUpperBound() != 1) {
            PapyrusObservableList list = this.domain == null ? EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source) : new PapyrusObservableList((List<?>)EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source), this.domain, this.getSource(featurePath), feature);
            return list;
        }
        PapyrusObservableValue value = this.domain == null ? EMFProperties.value((FeaturePath)featurePath).observe((Object)this.source) : new PapyrusObservableValue(this.getSource(featurePath), feature, this.domain);
        return value;
    }

    public boolean isEditable(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getMessage_Signature()) {
            return true;
        }
        if (feature == UMLPackage.eINSTANCE.getExtension_IsRequired()) {
            return true;
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Provided()) {
            return false;
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Required()) {
            return false;
        }
        return super.isEditable(propertyPath);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getMessage_Signature() || feature == UMLPackage.eINSTANCE.getSendOperationEvent_Operation() || feature == UMLPackage.eINSTANCE.getReceiveOperationEvent_Operation()) {
            return new SignatureContentProvider(this.source);
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Provided() || feature == UMLPackage.eINSTANCE.getPort_Required()) {
            Package root = null;
            if (((Element)this.source).getNearestPackage() != null) {
                root = PackageUtil.getRootPackage((Element)((Element)this.source));
            }
            String historyId = HistoryUtil.getHistoryID((EObject)this.source, (EStructuralFeature)feature, (EObject)root);
            UMLElementMEBContentProvider contentProvider = new UMLElementMEBContentProvider((EObject)root, historyId);
            contentProvider.setMetaClassWanted((Object)feature.getEType());
            return contentProvider;
        }
        if (feature instanceof EReference) {
            Package root = null;
            if (((Element)this.source).getNearestPackage() != null) {
                root = PackageUtil.getRootPackage((Element)((Element)this.source));
            }
            ServiceEditFilteredUMLContentProvider contentProvider = feature == UMLPackage.eINSTANCE.getInstanceValue_Instance() ? new InstanceValueContentProvider((InstanceValue)this.source, feature, (EObject)root) : new ServiceEditFilteredUMLContentProvider(this.source, feature, (EObject)root);
            contentProvider.setMetaClassWanted((Object)feature.getEType());
            contentProvider.setMetaClassNotWanted(Collections.EMPTY_LIST);
            return contentProvider;
        }
        return super.getContentProvider(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature != null && feature.getEType() instanceof EEnum) {
            return super.getLabelProvider(propertyPath);
        }
        return new UMLLabelProvider();
    }

    public boolean isOrdered(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.eINSTANCE.getStereotype_Icon()) {
            return true;
        }
        return super.isOrdered(propertyPath);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        boolean isOwnedRuleSubset;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (!(feature instanceof EReference)) {
            return null;
        }
        EReference reference = (EReference)feature;
        if (reference == UMLPackage.eINSTANCE.getMessage_Argument() && this.source instanceof Message) {
            HashSet<ParameterDirectionKind> directions = new HashSet<ParameterDirectionKind>();
            switch (((Message)this.source).getMessageSort()) {
                case REPLY_LITERAL: {
                    directions.add(ParameterDirectionKind.OUT_LITERAL);
                    directions.add(ParameterDirectionKind.INOUT_LITERAL);
                    directions.add(ParameterDirectionKind.RETURN_LITERAL);
                    return new MessageValueSpecificationFactory(reference, (Message)this.source, directions);
                }
                case SYNCH_CALL_LITERAL: 
                case ASYNCH_CALL_LITERAL: 
                case ASYNCH_SIGNAL_LITERAL: {
                    directions.add(ParameterDirectionKind.IN_LITERAL);
                    directions.add(ParameterDirectionKind.INOUT_LITERAL);
                    return new MessageValueSpecificationFactory(reference, (Message)this.source, directions);
                }
            }
        }
        if (isOwnedRuleSubset = ownedRuleSubsets.contains(reference)) {
            return new OwnedRuleCreationFactory(reference);
        }
        UMLPropertyEditorFactory factory = reference == UMLPackage.eINSTANCE.getConnector_Type() && this.source instanceof Connector ? new ConnectorTypeEditorFactory(reference) : new UMLPropertyEditorFactory(reference);
        EClass type = reference.getEReferenceType();
        factory.setContainerLabelProvider((ILabelProvider)new UMLLabelProvider());
        factory.setReferenceLabelProvider((ILabelProvider)new EMFObjectLabelProvider());
        ContainerContentProvider contentProvider = new ContainerContentProvider(type);
        factory.setContainerContentProvider((IStaticContentProvider)contentProvider);
        factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
        return factory;
    }
}

