/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.providers;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.properties.uml.util.UMLUtil;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.papyrus.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEvent;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.ReceiveOperationEvent;
import org.eclipse.uml2.uml.SendOperationEvent;
import org.eclipse.uml2.uml.Signal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureContentProvider
extends AbstractStaticContentProvider {
    private Message message;
    private MessageEvent sourceEvent;

    public SignatureContentProvider(EObject source) {
        if (source instanceof Message) {
            this.message = (Message)source;
        } else if (source instanceof ReceiveOperationEvent || source instanceof SendOperationEvent) {
            this.sourceEvent = (MessageEvent)source;
        } else {
            throw new IllegalArgumentException("The source EObject is not a valid element");
        }
    }

    public Object[] getElements() {
        if (this.message != null) {
            return this.getElementsFromMessage();
        }
        if (this.sourceEvent != null) {
            return this.getElementsFromEvent();
        }
        return new Object[0];
    }

    private Object[] getElementsFromMessage() {
        Class clazz = UMLUtil.getContextClassForMessage(this.message);
        return this.getElementsFromContext(clazz);
    }

    private Object[] getElementsFromEvent() {
        Class clazz = UMLUtil.getContextClassForMessageEvent(this.sourceEvent);
        if (clazz == null) {
            return new Object[0];
        }
        return this.getElementsFromContext(clazz);
    }

    private Object[] getElementsFromContext(Class clazz) {
        if (clazz == null) {
            return new Object[0];
        }
        LinkedList<Signal> result = new LinkedList<Signal>();
        result.addAll((Collection<Signal>)clazz.getOwnedOperations());
        if (this.message != null && (this.message.getMessageSort() == MessageSort.ASYNCH_CALL_LITERAL || this.message.getMessageSort() == MessageSort.ASYNCH_SIGNAL_LITERAL)) {
            result.addAll(this.getAllSignals((Element)clazz));
        }
        return result.toArray();
    }

    private List<Signal> getAllSignals(Element element) {
        LinkedList<Signal> result = new LinkedList<Signal>();
        HashSet<Package> browsedPackages = new HashSet<Package>();
        Package rootPackage = PackageUtil.getRootPackage((Element)element);
        this.fillSignals(result, rootPackage, browsedPackages);
        return result;
    }

    private void fillSignals(Collection<Signal> result, Package rootPackage, Set<Package> browsedPackages) {
        if (browsedPackages.contains(rootPackage)) {
            return;
        }
        browsedPackages.add(rootPackage);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)rootPackage, (boolean)true);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (eObject instanceof Signal) {
                result.add((Signal)eObject);
                continue;
            }
            if (!(eObject instanceof PackageImport)) continue;
            PackageImport packageImport = (PackageImport)eObject;
            Package importedPackage = packageImport.getImportedPackage();
            this.fillSignals(result, importedPackage, browsedPackages);
        }
    }
}

