/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.core.utils.PapyrusEcoreUtils;
import org.eclipse.papyrus.properties.uml.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.properties.util.EMFHelper;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEvent;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLUtil {
    private static EPackage umlMetamodel = UMLPackage.eINSTANCE;

    public static Element resolveUMLElement(Object source) {
        EObject eElement = null;
        if (source instanceof EObject) {
            eElement = (EObject)source;
        }
        if (source instanceof IAdaptable) {
            eElement = (EObject)((IAdaptable)source).getAdapter(EObject.class);
        }
        if (EMFHelper.isInstance((EObject)eElement, (String)"Element", (EPackage)umlMetamodel)) {
            return (Element)eElement;
        }
        return null;
    }

    public static boolean isSubClass(String className, String superclassName) {
        EClass eClass = (EClass)umlMetamodel.getEClassifier(className);
        EClass superClass = (EClass)umlMetamodel.getEClassifier(superclassName);
        return superClass.isSuperTypeOf(eClass);
    }

    public static IGraphicalEditPart resolveEditPart(Object source) {
        if (source instanceof IGraphicalEditPart) {
            return (IGraphicalEditPart)source;
        }
        if (source instanceof IAdaptable) {
            return (IGraphicalEditPart)((IAdaptable)source).getAdapter(IGraphicalEditPart.class);
        }
        return null;
    }

    public static EditingDomain resolveEditingDomain(Object source) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)UMLUtil.resolveUMLElement(source));
    }

    public static EPackage getUMLMetamodel() {
        return umlMetamodel;
    }

    public static Stereotype getAppliedStereotype(Element umlElement, String stereotypeName, boolean strict) {
        Stereotype stereotype = umlElement.getAppliedStereotype(stereotypeName);
        if (strict || stereotype != null) {
            return stereotype;
        }
        stereotype = UMLUtil.findStereotype(umlElement, stereotypeName);
        if (stereotype == null) {
            return null;
        }
        Iterator iterator = umlElement.getAppliedSubstereotypes(stereotype).iterator();
        if (iterator.hasNext()) {
            Stereotype appliedStereotype = (Stereotype)iterator.next();
            return appliedStereotype;
        }
        return null;
    }

    public static Stereotype findStereotype(Element umlElement, String stereotypeName) {
        Stereotype stereotype = null;
        Package umlPackage = umlElement.getNearestPackage();
        if (umlPackage == null) {
            stereotype = umlElement.getApplicableStereotype(stereotypeName);
        } else {
            block0: for (Profile profile : umlPackage.getAllAppliedProfiles()) {
                for (Stereotype ownedStereotype : profile.getOwnedStereotypes()) {
                    if (!ownedStereotype.getQualifiedName().equals(stereotypeName)) continue;
                    stereotype = ownedStereotype;
                    break block0;
                }
            }
        }
        return stereotype;
    }

    public static Collection<Stereotype> getAllSuperStereotypes(Stereotype stereotype) {
        HashSet<Stereotype> result = new HashSet<Stereotype>();
        if (stereotype != null) {
            UMLUtil.getAllSuperStereotypes(stereotype, result);
        }
        return result;
    }

    private static void getAllSuperStereotypes(Stereotype stereotype, Set<Stereotype> result) {
        result.add(stereotype);
        for (Classifier superClassifier : stereotype.getGenerals()) {
            if (!(superClassifier instanceof Stereotype) || result.contains(superClassifier)) continue;
            UMLUtil.getAllSuperStereotypes((Stereotype)superClassifier, result);
        }
    }

    public static Class getContextClassForMessage(Message message) {
        MessageOccurrenceSpecification receiveEvent = (MessageOccurrenceSpecification)message.getReceiveEvent();
        if (receiveEvent == null) {
            return null;
        }
        return UMLUtil.getContextClassForMessageOccurrence(receiveEvent);
    }

    public static Class getContextClassForMessageOccurrence(MessageOccurrenceSpecification messageOccurrence) {
        EList lifelines = messageOccurrence.getCovereds();
        if (lifelines.isEmpty()) {
            return null;
        }
        if (lifelines.size() == 1) {
            Lifeline lifeline = (Lifeline)lifelines.get(0);
            ConnectableElement element = lifeline.getRepresents();
            if (element == null) {
                return null;
            }
            Type type = element.getType();
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz;
            }
            return null;
        }
        return null;
    }

    public static Class getContextClassForMessageEvent(MessageEvent event) {
        Collection settings = PapyrusEcoreUtils.getUsages((EObject)event);
        if (settings.isEmpty()) {
            return null;
        }
        if (settings.size() == 1) {
            EObject referer = ((EStructuralFeature.Setting)settings.iterator().next()).getEObject();
            if (referer instanceof MessageOccurrenceSpecification) {
                return UMLUtil.getContextClassForMessageOccurrence((MessageOccurrenceSpecification)referer);
            }
            return null;
        }
        MessageOccurrenceSpecification referer = null;
        EObject newReferer = null;
        for (EStructuralFeature.Setting setting : settings) {
            newReferer = setting.getEObject();
            if (!(newReferer instanceof MessageOccurrenceSpecification)) continue;
            if (referer == null || referer == newReferer) {
                referer = (MessageOccurrenceSpecification)newReferer;
                continue;
            }
            referer = null;
            break;
        }
        if (referer == null) {
            return null;
        }
        return UMLUtil.getContextClassForMessageOccurrence(referer);
    }

    public static IObservableValue getObservableValue(EObject source, EStructuralFeature feature, EditingDomain domain) {
        return domain == null ? EMFProperties.value((EStructuralFeature)feature).observe((Object)source) : new PapyrusObservableValue(source, feature, domain);
    }
}

