/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.papyrus.properties.modelelement.ModelElement;
import org.eclipse.papyrus.properties.uml.expression.ExpressionList;
import org.eclipse.papyrus.properties.uml.preferences.LanguageRegistry;
import org.eclipse.papyrus.properties.uml.widgets.BodyEditor;
import org.eclipse.papyrus.properties.uml.widgets.NullBodyEditor;
import org.eclipse.papyrus.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DynamicBodyEditor
extends AbstractValueEditor
implements Listener {
    private BodyEditor currentEditor;
    private final Composite bodyEditorContainer;
    private final Set<Listener> changeListeners = new HashSet<Listener>();
    private boolean readOnly = false;
    private ModelElement context = null;

    public DynamicBodyEditor(Composite parent, int style) {
        super(parent, style);
        this.bodyEditorContainer = new Composite((Composite)this, style);
        this.bodyEditorContainer.setLayout((Layout)new FillLayout());
        this.bodyEditorContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.currentEditor = new NullBodyEditor();
        this.currentEditor.createWidget(this.bodyEditorContainer, 0);
    }

    public void display(ExpressionList.Expression expression) {
        if (this.currentEditor != null) {
            this.disposeBodyEditor();
        }
        if (expression == null) {
            NullBodyEditor editor = new NullBodyEditor();
            editor.createWidget(this.bodyEditorContainer, 0);
            this.bodyEditorContainer.layout();
            return;
        }
        String language = expression.getLanguage();
        String initialText = expression.getBody();
        BodyEditor editor = this.getEditor(language);
        editor.createWidget(this.bodyEditorContainer, 0);
        if (this.context != null) {
            editor.setContext(this.context);
        }
        editor.setInput(initialText);
        editor.addChangeListener(this);
        editor.setReadOnly(this.readOnly);
        this.bodyEditorContainer.layout();
        this.currentEditor = editor;
    }

    public void addChangeListener(Listener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(Listener listener) {
        this.changeListeners.remove(listener);
    }

    private BodyEditor getEditor(String language) {
        return LanguageRegistry.instance.getEditorFor(language);
    }

    private void disposeBodyEditor() {
        this.currentEditor.removeChangeListener(this);
        this.currentEditor.dispose();
        Control[] controlArray = this.bodyEditorContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    public String getValue() {
        if (this.currentEditor != null) {
            return this.currentEditor.getValue();
        }
        return null;
    }

    public Object getEditableType() {
        return String.class;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.currentEditor != null) {
            this.currentEditor.setReadOnly(readOnly);
        }
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setToolTipText(String text) {
        super.setLabelToolTipText(text);
    }

    public void handleEvent(Event event) {
        for (Listener listener : this.changeListeners) {
            listener.handleEvent(event);
        }
    }

    protected GridData getLabelLayoutData() {
        GridData result = super.getLabelLayoutData();
        result.verticalAlignment = 1;
        return result;
    }

    public void setContext(ModelElement modelElement) {
        this.context = modelElement;
        if (this.currentEditor != null) {
            this.currentEditor.setContext(this.context);
        }
    }
}

