/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.widgets;

import java.util.LinkedList;
import org.eclipse.papyrus.properties.uml.expression.ExpressionList;
import org.eclipse.papyrus.properties.uml.preferences.LanguageRegistry;
import org.eclipse.papyrus.properties.widgets.layout.GridData;
import org.eclipse.papyrus.properties.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.widgets.selectors.StringSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class LanguageSelector
extends StringSelector {
    private Text text;
    private List list;

    public Object[] getSelectedElements() {
        LinkedList<String> languageNames = new LinkedList<String>();
        if (this.text.getText() != null && !this.text.getText().trim().equals("")) {
            languageNames.add(this.text.getText());
        } else {
            String[] selection = this.list.getSelection();
            if (selection.length > 0) {
                String[] stringArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    String languageName = stringArray[n2];
                    languageNames.add(languageName);
                    ++n2;
                }
            }
            this.list.setSelection(-1);
        }
        LinkedList<ExpressionList.Expression> result = new LinkedList<ExpressionList.Expression>();
        for (String languageName : languageNames) {
            ExpressionList.Expression expression = new ExpressionList.Expression();
            expression.setLanguage(languageName);
            result.add(expression);
        }
        this.text.setText("");
        return result.toArray();
    }

    public void createControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new PropertiesLayout());
        this.text = new Text(container, 2048);
        this.list = new List(container, 2050);
        this.list.setLayoutData((Object)new GridData(4, 4, true, true));
        for (String language : LanguageRegistry.instance.getLanguages()) {
            this.list.add(language);
        }
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!LanguageSelector.this.elementSelectionListeners.isEmpty()) {
                    Object[] value = LanguageSelector.this.getSelectedElements();
                    for (IElementSelectionListener listener : LanguageSelector.this.elementSelectionListeners) {
                        listener.addElements(value);
                    }
                }
            }
        });
    }

    public Object[] getAllElements() {
        LinkedList<ExpressionList.Expression> result = new LinkedList<ExpressionList.Expression>();
        String[] stringArray = this.list.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            ExpressionList.Expression expression = new ExpressionList.Expression();
            expression.setLanguage(language);
            result.add(expression);
            ++n2;
        }
        this.list.setSelection(-1);
        return result.toArray();
    }
}

