/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.uml.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.properties.modelelement.ModelElement;
import org.eclipse.papyrus.properties.uml.modelelement.UMLModelElement;
import org.eclipse.papyrus.properties.uml.util.UMLUtil;
import org.eclipse.papyrus.properties.uml.widgets.SelectOrCreateDialogEditor;
import org.eclipse.papyrus.properties.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEvent;
import org.eclipse.uml2.uml.UMLPackage;

public class SelectOrCreateDialogPropertyEditor
extends AbstractPropertyEditor {
    private static Set<EClass> validEClasses = new HashSet<EClass>();
    private static Set<EStructuralFeature> validFeatures = new HashSet<EStructuralFeature>();
    protected SelectOrCreateDialogEditor editor;

    static {
        validEClasses.add(UMLPackage.eINSTANCE.getMessageEvent());
        validEClasses.add(UMLPackage.eINSTANCE.getMessage());
        validFeatures.add((EStructuralFeature)UMLPackage.eINSTANCE.getSendOperationEvent_Operation());
        validFeatures.add((EStructuralFeature)UMLPackage.eINSTANCE.getReceiveOperationEvent_Operation());
        validFeatures.add((EStructuralFeature)UMLPackage.eINSTANCE.getSendSignalEvent_Signal());
        validFeatures.add((EStructuralFeature)UMLPackage.eINSTANCE.getReceiveSignalEvent_Signal());
        validFeatures.add((EStructuralFeature)UMLPackage.eINSTANCE.getMessage_Signature());
    }

    public SelectOrCreateDialogPropertyEditor(Composite parent, int style) {
        this.editor = new SelectOrCreateDialogEditor(parent, style);
        this.setEditor((AbstractValueEditor)this.editor);
    }

    protected void doBinding() {
        super.doBinding();
        this.editor.setContentProvider(this.input.getContentProvider(this.propertyPath));
        this.editor.setLabelProvider(this.input.getLabelProvider(this.propertyPath));
        ModelElement element = this.input.getModelElement(this.propertyPath);
        if (element instanceof UMLModelElement) {
            UMLModelElement umlModelElement = (UMLModelElement)element;
            EStructuralFeature feature = umlModelElement.getFeature(this.getLocalPropertyPath());
            EObject sourceElement = umlModelElement.getSource();
            if (!this.isValidFeature(feature)) {
                throw new IllegalArgumentException("The widget SelectOrCreateDialogPropertyEditor cannot be used with this property : " + this.propertyPath);
            }
            if (!this.isValidEObject(sourceElement)) {
                throw new IllegalArgumentException("The widget SelectOrCreateDialogPropertyEditor cannot be used with this kind of object : " + sourceElement.eClass());
            }
            Class parentClass = this.findParentClass(sourceElement);
            if (parentClass != null) {
                this.editor.setCreateAs(UMLPackage.eINSTANCE.getOperation(), (EObject)parentClass, (EStructuralFeature)UMLPackage.eINSTANCE.getClass_OwnedOperation());
                this.editor.setCreateAs(UMLPackage.eINSTANCE.getSignal(), (EObject)parentClass.getNearestPackage(), (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement());
            }
            this.editor.setEditingDomain(umlModelElement.getDomain());
        }
    }

    private Class findParentClass(EObject sourceElement) {
        if (sourceElement instanceof Message) {
            return UMLUtil.getContextClassForMessage((Message)sourceElement);
        }
        if (sourceElement instanceof MessageEvent) {
            return UMLUtil.getContextClassForMessageEvent((MessageEvent)sourceElement);
        }
        return null;
    }

    private boolean isValidEObject(EObject sourceElement) {
        for (EClass eClass : validEClasses) {
            if (!eClass.isInstance((Object)sourceElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return validFeatures.contains(feature);
    }
}

