/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.readonly;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.readonly.IReadOnlyHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FSReadOnlyHandler
implements IReadOnlyHandler {
    public boolean isReadOnly(IFile[] files) {
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file != null && file.isReadOnly()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean enableWrite(final IFile[] files) {
        final AtomicBoolean doEnableWrite = new AtomicBoolean();
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                String message = "Do you want to remove read only flag on those files ?\n\n";
                IFile[] iFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file = iFileArray[n2];
                    message = String.valueOf(message) + file.getName() + "\n";
                    ++n2;
                }
                doEnableWrite.set(MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Enable write", (String)message));
            }
        });
        if (doEnableWrite.get()) {
            boolean ok = true;
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file != null) {
                    try {
                        ResourceAttributes att = file.getResourceAttributes();
                        att.setReadOnly(false);
                        file.setResourceAttributes(att);
                    }
                    catch (CoreException e) {
                        ok = false;
                    }
                }
                ++n2;
            }
            return ok;
        }
        return false;
    }
}

