/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.readonly;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.internal.command.ICommandWithSettableResult;
import org.eclipse.papyrus.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.onefile.utils.OneFileUtils;
import org.eclipse.papyrus.readonly.ReadOnlyManager;

public class FSReadOnlyOneFileApprover
implements IOperationApprover2 {
    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        return this.proceedExecuting(operation, history, info);
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        return this.proceedExecuting(operation, history, info);
    }

    public IStatus proceedExecuting(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        if (operation instanceof ICommand) {
            boolean ok;
            IFile[] filesToCheckForLockArray;
            ICommand command = (ICommand)operation;
            List affectedFiles = command.getAffectedFiles();
            HashSet<IFile> filesToCheckForLock = new HashSet<IFile>();
            for (IFile affectedFile : affectedFiles) {
                if (affectedFile == null) continue;
                if (affectedFile.exists()) {
                    IPapyrusFile papFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(affectedFile);
                    filesToCheckForLock.addAll(Arrays.asList(OneFileUtils.getAssociatedFiles((IPapyrusFile)papFile)));
                    continue;
                }
                IPath path = affectedFile.getRawLocation();
                if (path == null) {
                    FSReadOnlyOneFileApprover.setCommandResult(command, Status.CANCEL_STATUS);
                    return Status.CANCEL_STATUS;
                }
                File file = path.toFile();
                if (file == null || !file.exists() || file.canWrite()) continue;
                FSReadOnlyOneFileApprover.setCommandResult(command, Status.CANCEL_STATUS);
                return Status.CANCEL_STATUS;
            }
            for (IFile file : affectedFiles) {
                URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            }
            if (filesToCheckForLock.size() > 0 && ReadOnlyManager.isReadOnly(filesToCheckForLock.toArray(filesToCheckForLockArray = filesToCheckForLock.toArray(new IFile[filesToCheckForLock.size()]))) && !(ok = ReadOnlyManager.enableWrite(filesToCheckForLockArray))) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    public static void setCommandResult(ICommand command, IStatus status) {
        if (command instanceof ICommandWithSettableResult) {
            ((ICommandWithSettableResult)command).internalSetResult(new CommandResult(status));
        }
    }
}

