/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.readonly;

import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.readonly.IReadOnlyHandler;

public class ReadOnlyManager {
    protected static final IReadOnlyHandler[] orderedHandlersArray;

    static {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.readonly", "readOnlyHandler");
        LinkedList<HandlerPriorityPair> handlerPriorityPairs = new LinkedList<HandlerPriorityPair>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if ("readOnlyHandler".equals(elem.getName())) {
                try {
                    HandlerPriorityPair handlerPriorityPair = new HandlerPriorityPair();
                    handlerPriorityPair.handler = (IReadOnlyHandler)elem.createExecutableExtension("class");
                    handlerPriorityPair.priority = Integer.parseInt(elem.getAttribute("priority"));
                    handlerPriorityPairs.add(handlerPriorityPair);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        Collections.sort(handlerPriorityPairs);
        orderedHandlersArray = new IReadOnlyHandler[handlerPriorityPairs.size()];
        int i = 0;
        while (i < orderedHandlersArray.length) {
            ReadOnlyManager.orderedHandlersArray[i] = ((HandlerPriorityPair)handlerPriorityPairs.get((int)i)).handler;
            ++i;
        }
    }

    public static boolean isReadOnly(Resource resource) {
        if (resource != null && resource.getURI() != null) {
            if (resource.getURI().isPlatform()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)));
                if (ReadOnlyManager.isReadOnly(file)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean isReadOnly(IFile file) {
        return ReadOnlyManager.isReadOnly(new IFile[]{file});
    }

    public static boolean isReadOnly(IFile[] files) {
        int i = 0;
        while (i < orderedHandlersArray.length) {
            if (orderedHandlersArray[i].isReadOnly(files)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean enableWrite(IFile[] files) {
        int i = 0;
        while (i < orderedHandlersArray.length) {
            boolean ok;
            if (orderedHandlersArray[i].isReadOnly(files) && !(ok = orderedHandlersArray[i].enableWrite(files))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HandlerPriorityPair
    implements Comparable<HandlerPriorityPair> {
        public IReadOnlyHandler handler;
        public int priority;

        protected HandlerPriorityPair() {
        }

        @Override
        public int compareTo(HandlerPriorityPair o) {
            if (o.priority > this.priority) {
                return 1;
            }
            if (o.priority < this.priority) {
                return -1;
            }
            return 0;
        }
    }
}

