/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.readonly.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.utils.BusinessModelResolver;
import org.eclipse.papyrus.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.onefile.utils.OneFileUtils;
import org.eclipse.papyrus.readonly.ReadOnlyManager;
import org.eclipse.ui.PlatformUI;

public class EnableWriteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject elem = this.getSelectedElement();
        if (elem != null && elem.eResource() != null && elem.eResource().getResourceSet() != null) {
            Resource res = elem.eResource();
            ResourceSet rs = res.getResourceSet();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(res.getURI().toPlatformString(true)));
            IPapyrusFile papFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(file);
            IFile[] associatedFiles = OneFileUtils.getAssociatedFiles((IPapyrusFile)papFile);
            ReadOnlyManager.enableWrite(associatedFiles);
            IFile[] iFileArray = associatedFiles;
            int n = associatedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile associatedFile = iFileArray[n2];
                URI associatedUri = URI.createPlatformResourceURI((String)associatedFile.getFullPath().toString(), (boolean)true);
                Resource associatedResource = rs.getResource(associatedUri, true);
                if (associatedResource != null) {
                    associatedResource.setModified(true);
                }
                ++n2;
            }
        }
        return null;
    }

    protected EObject getSelectedElement() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            return this.resolveSemanticObject(obj);
        }
        return null;
    }

    protected EObject resolveSemanticObject(Object object) {
        Object businessObject = BusinessModelResolver.getInstance().getBusinessModel(object);
        if (businessObject instanceof EObject) {
            return (EObject)businessObject;
        }
        return null;
    }
}

