/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.resource.migration.controller;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.resource.ResourcePackage;
import org.eclipse.papyrus.resource.migration.controller.exceptions.URINotValidException;

public class GenModelUpdater {
    private static final URI uriForResourceGenModel = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.resource/model/resource.genmodel");
    private static final URI uriForEclassResourceEObject = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.resource/model/resource.ecore#//ResourceEObject");
    private ResourcePackage resourcePackage = ResourcePackage.eINSTANCE;
    private EClass resourceEObjectEClass = null;
    private EPackage currentEPackage = null;

    public void transform(URI uri) throws URINotValidException, IOException {
        if (uri == null) {
            throw new URINotValidException("uri is null");
        }
        ResourceSetImpl set = new ResourceSetImpl();
        try {
            Resource resource = set.getResource(uri, true);
            if (resource != null) {
                EObject e = (EObject)resource.getContents().get(0);
                if (e instanceof GenModel) {
                    GenModel genmodel = (GenModel)e;
                    Resource toSave = this.update(genmodel);
                    if (toSave != null) {
                        resource.save(Collections.EMPTY_MAP);
                        toSave.save(Collections.EMPTY_MAP);
                    }
                } else {
                    throw new URINotValidException("uri " + uri.toString() + "doesn't reference a genmodel");
                }
            }
            for (Resource r : set.getResources()) {
                if (!r.isLoaded()) continue;
                try {
                    r.unload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (RuntimeException e) {
            throw new URINotValidException("uri " + uri.toString() + "not valid");
        }
    }

    private Resource update(GenModel genmodel) {
        EObject root;
        Resource resourceForResourceGenmodel;
        Resource result = null;
        boolean found = false;
        for (GenPackage p : genmodel.getUsedGenPackages()) {
            found |= this.resourcePackage.equals(p.getEcorePackage());
        }
        if (!found && (resourceForResourceGenmodel = genmodel.eResource().getResourceSet().getResource(uriForResourceGenModel, true)) != null && (root = (EObject)resourceForResourceGenmodel.getContents().get(0)) instanceof GenModel) {
            EObject resourceEObjectEobject;
            GenModel model = (GenModel)root;
            genmodel.getUsedGenPackages().add((Object)((GenPackage)model.getGenPackages().get(0)));
            Resource resourceResource = genmodel.eResource().getResourceSet().getResource(uriForEclassResourceEObject.trimFragment(), true);
            if (resourceResource != null && (resourceEObjectEobject = resourceResource.getEObject(uriForEclassResourceEObject.fragment())) instanceof EClass) {
                this.resourceEObjectEClass = (EClass)resourceEObjectEobject;
                result = this.addResourceEobjectInheritance(genmodel);
            }
        }
        return result;
    }

    private Resource addResourceEobjectInheritance(GenModel genmodel) {
        EcoreUtil.resolveAll((ResourceSet)genmodel.eResource().getResourceSet());
        Resource result = null;
        EList packages = genmodel.getGenPackages();
        if (packages.size() > 0) {
            GenPackage genPackage = (GenPackage)packages.get(0);
            this.currentEPackage = genPackage.getEcorePackage();
            result = this.currentEPackage.eResource();
            this.manageEPackage(this.currentEPackage);
        }
        return result;
    }

    private void manageEPackage(EPackage currentEPackage2) {
        for (EClassifier eclassifier : currentEPackage2.getEClassifiers()) {
            if (!(eclassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eclassifier;
            this.manageEClass(eClass);
        }
        for (EPackage ePackage : currentEPackage2.getESubpackages()) {
            this.manageEPackage(ePackage);
        }
    }

    private void manageEClass(EClass eClass) {
        if (eClass != this.resourceEObjectEClass) {
            if (eClass.getESuperTypes().size() == 0) {
                if (this.isACorrectEPackage(eClass.getEPackage())) {
                    eClass.getESuperTypes().add((Object)this.resourceEObjectEClass);
                }
            } else {
                boolean toAdd = true;
                for (EClass eClass2 : eClass.getESuperTypes()) {
                    toAdd &= !this.isACorrectEPackage(eClass2.getEPackage());
                    this.manageEClass(eClass2);
                }
                if (toAdd) {
                    eClass.getESuperTypes().add((Object)this.resourceEObjectEClass);
                }
            }
        }
    }

    private boolean isACorrectEPackage(EPackage ePackage) {
        EPackage current = ePackage;
        while (current != null && current != this.currentEPackage) {
            current = current.getESuperPackage();
        }
        return current == this.currentEPackage;
    }
}

