/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.resource.migration.popup.actions;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.resource.migration.controller.GenModelUpdater;
import org.eclipse.papyrus.resource.migration.controller.exceptions.URINotValidException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UpdateGenModelAction
implements IObjectActionDelegate {
    private Shell shell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        ISelectionService service;
        ISelection selection;
        IWorkbenchWindow window;
        IWorkbench workbench;
        if (PlatformUI.getWorkbench() != null && (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow() != null && (window = workbench.getActiveWorkbenchWindow()).getSelectionService() != null && (selection = (service = window.getSelectionService()).getSelection()) instanceof IStructuredSelection) {
            final IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    UpdateGenModelAction.this.runProcess(structuredSelection);
                }
            });
        }
    }

    private void runProcess(IStructuredSelection structuredSelection) {
        try {
            Iterator iterator = structuredSelection.iterator();
            GenModelUpdater updater = new GenModelUpdater();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof IFile)) continue;
                IFile ifile = (IFile)next;
                updater.transform(URI.createURI((String)ifile.getLocationURI().toString()));
                ifile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            MessageDialog.openInformation((Shell)this.shell, (String)"Finish", (String)"The genmodel has been updated");
        }
        catch (URINotValidException e) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)"An error occurs during save process");
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

