/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.contentprovider.di.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.papyrus.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.sasheditor.contentprovider.IContentChangedProvider;
import org.eclipse.papyrus.sashwindows.di.AbstractPanel;
import org.eclipse.papyrus.sashwindows.di.PageRef;
import org.eclipse.papyrus.sashwindows.di.SashModel;
import org.eclipse.papyrus.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.sashwindows.di.Window;

public class ContentChangedEventProvider
implements IContentChangedProvider {
    private List<IContentChangedListener> listeners;
    private boolean isDeliverEnable = true;
    private IContentChangedListener.ContentEvent storedEvent;
    private EMFAdapter emfAdapter = new EMFAdapter();
    private SashModel diSashModel;

    public ContentChangedEventProvider(SashModel diSashModel) {
        this.diSashModel = diSashModel;
        this.activate();
    }

    public ContentChangedEventProvider(SashWindowsMngr sashWindowMngr) {
        this(sashWindowMngr.getSashModel());
    }

    protected void activate() {
        this.diSashModel.eAdapters().add((Object)this.emfAdapter);
        this.setDeliver(true);
    }

    protected void deactivate() {
        this.setDeliver(false);
        this.diSashModel.eAdapters().remove((Object)this.emfAdapter);
    }

    protected boolean isDeliver() {
        return this.isDeliverEnable;
    }

    protected void setDeliver(boolean isDeliverEnable) {
        if (this.isDeliverEnable == isDeliverEnable) {
            return;
        }
        if (!this.isDeliverEnable) {
            this.isDeliverEnable = true;
            if (this.storedEvent != null) {
                this.fireContentChanged(this.storedEvent);
            }
        } else {
            this.isDeliverEnable = isDeliverEnable;
        }
        this.storedEvent = null;
    }

    public void addListener(IContentChangedListener listener) {
        if (this.listeners == null) {
            this.createListeners();
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(IContentChangedListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void createListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IContentChangedListener>();
        }
    }

    protected void fireContentChanged(IContentChangedListener.ContentEvent event) {
        if (this.listeners == null) {
            return;
        }
        if (!this.isDeliverEnable) {
            this.storedEvent = event;
            return;
        }
        for (IContentChangedListener listener : this.listeners) {
            listener.contentChanged(event);
        }
    }

    public class EMFAdapter
    extends EContentAdapter {
        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getEventType() == 9) {
                return;
            }
            Object sender = msg.getNotifier();
            if (sender instanceof AbstractPanel || sender instanceof Window || sender instanceof PageRef) {
                ContentChangedEventProvider.this.fireContentChanged(new IContentChangedListener.ContentEvent(msg.getEventType(), sender, null));
            }
        }
    }
}

