/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.contentprovider.di.internal;

import org.eclipse.papyrus.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.sasheditor.contentprovider.di.IPageModelFactory;
import org.eclipse.papyrus.sasheditor.contentprovider.di.internal.ContentChangedEventProvider;
import org.eclipse.papyrus.sasheditor.contentprovider.di.internal.SashPanelModel;
import org.eclipse.papyrus.sasheditor.contentprovider.di.internal.TabFolderModel;
import org.eclipse.papyrus.sashwindows.di.DiFactory;
import org.eclipse.papyrus.sashwindows.di.SashModel;
import org.eclipse.papyrus.sashwindows.di.SashPanel;
import org.eclipse.papyrus.sashwindows.di.TabFolder;
import org.eclipse.papyrus.sashwindows.di.Window;

public class DiContentProvider
implements ISashWindowsContentProvider {
    private SashModel diSashModel;
    private IPageModelFactory pageModelFactory;
    private ContentChangedEventProvider contentChangedEventProvider;

    public DiContentProvider(SashModel diSashModel, IPageModelFactory pageModelFactory) throws IllegalArgumentException {
        this(diSashModel, pageModelFactory, new ContentChangedEventProvider(diSashModel));
    }

    public DiContentProvider(SashModel diSashModel, IPageModelFactory pageModelFactory, ContentChangedEventProvider contentChangedEventProvider) throws IllegalArgumentException {
        if (pageModelFactory == null) {
            throw new IllegalArgumentException("A IPageModelFactory should be provided.");
        }
        this.diSashModel = diSashModel;
        this.pageModelFactory = pageModelFactory;
        this.contentChangedEventProvider = contentChangedEventProvider;
    }

    protected SashModel getDiSashModel() {
        return this.diSashModel;
    }

    protected ContentChangedEventProvider getContentChangedEventProvider() {
        return this.contentChangedEventProvider;
    }

    public void addPage(Object pageIdentifier) {
        this.diSashModel.addPage(pageIdentifier);
    }

    public void addPage(Object page, int index) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void createFolder(ITabFolderModel tabFolder, int tabIndex, ITabFolderModel targetFolder, int side) {
        this.contentChangedEventProvider.setDeliver(false);
        TabFolder newFolder = DiFactory.eINSTANCE.createTabFolder();
        TabFolder refFolder = ((TabFolderModel)targetFolder).getTabFolder();
        TabFolder pageSrcFolder = ((TabFolderModel)tabFolder).getTabFolder();
        this.diSashModel.insertFolder(newFolder, refFolder, side);
        this.diSashModel.movePage(pageSrcFolder, tabIndex, newFolder);
        this.diSashModel.removeEmptyFolder(pageSrcFolder);
        this.diSashModel.setCurrentSelection(newFolder);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void setCurrentFolder(Object rawModel) {
        if (!(rawModel instanceof TabFolder)) {
            return;
        }
        this.diSashModel.setCurrentSelection((TabFolder)rawModel);
    }

    public Object getRootModel() {
        return ((Window)this.diSashModel.getWindows().get(0)).getPanel();
    }

    public IAbstractPanelModel createChildSashModel(Object root) {
        if (root instanceof SashPanel) {
            return new SashPanelModel((SashPanel)root, this.pageModelFactory);
        }
        if (root instanceof TabFolder) {
            return new TabFolderModel((TabFolder)root, this.pageModelFactory);
        }
        throw new IllegalArgumentException("Can't create IPanelModel from raw model '" + root + "'.");
    }

    public void movePage(ITabFolderModel folderModel, int oldIndex, int newIndex) {
        TabFolder folder = ((TabFolderModel)folderModel).getTabFolder();
        this.contentChangedEventProvider.setDeliver(false);
        folder.movePage(oldIndex, newIndex);
        this.diSashModel.setCurrentSelection(folder);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void movePage(ITabFolderModel srcFolderModel, int sourceIndex, ITabFolderModel targetFolderModel, int targetIndex) {
        TabFolder srcFolder = ((TabFolderModel)srcFolderModel).getTabFolder();
        TabFolder targetFolder = ((TabFolderModel)targetFolderModel).getTabFolder();
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.movePage(srcFolder, sourceIndex, targetFolder, targetIndex);
        this.diSashModel.removeEmptyFolder(srcFolder);
        this.diSashModel.setCurrentSelection(targetFolder);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void removePage(int index) {
        this.diSashModel.removePage(index);
    }

    public void removePage(Object page) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void removePage(ITabFolderModel parentFolder, int tabIndex) {
        TabFolder folder = ((TabFolderModel)parentFolder).getTabFolder();
        this.contentChangedEventProvider.setDeliver(false);
        folder.removePage(tabIndex);
        this.diSashModel.removeEmptyFolder(folder);
        this.contentChangedEventProvider.setDeliver(true);
    }

    protected void firePropertyChanged(IContentChangedListener.ContentEvent event) {
        this.contentChangedEventProvider.fireContentChanged(event);
    }
}

