/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sasheditor.contentprovider.di.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.sasheditor.contentprovider.di.internal.ContentChangedEventProvider;
import org.eclipse.papyrus.sasheditor.editor.IPage;
import org.eclipse.papyrus.sashwindows.di.PageRef;
import org.eclipse.papyrus.sashwindows.di.SashWindowsMngr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageMngrImpl
implements IPageMngr {
    private SashWindowsMngr diSashModel;
    private Stack<Object> previousStack = new Stack();
    private Stack<Object> nextStack = new Stack();
    private boolean updating = false;
    private boolean closingPage = false;
    ContentChangedEventProvider contentChangedEventProvider;

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public boolean isClosingPage() {
        return this.closingPage;
    }

    public void setClosingPage(boolean closingPage) {
        this.closingPage = closingPage;
    }

    public PageMngrImpl(SashWindowsMngr diSashModel, ContentChangedEventProvider contentChangedEventProvider) {
        this.diSashModel = diSashModel;
        this.contentChangedEventProvider = contentChangedEventProvider;
        if (diSashModel.getSashModel() != null && diSashModel.getSashModel().getCurrentSelection() != null && !diSashModel.getSashModel().getCurrentSelection().getChildren().isEmpty()) {
            this.addToPreviousStack(((PageRef)diSashModel.getSashModel().getCurrentSelection().getChildren().get(0)).getPageIdentifier());
        }
    }

    public void addPage(Object pageIdentifier) {
        this.diSashModel.getPageList().addPage(pageIdentifier);
    }

    public List<Object> allPages() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (PageRef pageRef : this.diSashModel.getPageList().getAvailablePage()) {
            list.add(pageRef.getPageIdentifier());
        }
        return list;
    }

    public void closePage(Object pageIdentifier) {
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.getSashModel().removePage(pageIdentifier);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void closeAllOpenedPages() {
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.getSashModel().removeAllPages();
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void closeOtherPages(Object pageIdentifier) {
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.getSashModel().removeOtherPages(pageIdentifier);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void openPage(Object pageIdentifier) {
        this.addToPreviousStack(pageIdentifier);
        Iterator iterator = this.diSashModel.getPageList().getAvailablePage().iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            if (!pageIdentifier.equals(((PageRef)iterator.next()).getPageIdentifier())) continue;
            found = true;
        }
        if (!found) {
            this.diSashModel.getPageList().addPage(pageIdentifier);
        }
        this.diSashModel.getSashModel().addPage(pageIdentifier);
    }

    private void openPageWithoutStack(Object pageIdentifier) {
        Iterator iterator = this.diSashModel.getPageList().getAvailablePage().iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            if (!pageIdentifier.equals(((PageRef)iterator.next()).getPageIdentifier())) continue;
            found = true;
        }
        if (!found) {
            this.diSashModel.getPageList().addPage(pageIdentifier);
        }
        this.diSashModel.getSashModel().addPage(pageIdentifier);
    }

    public void removePage(Object pageIdentifier) {
        this.diSashModel.getPageList().removePage(pageIdentifier);
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.getSashModel().removePage(pageIdentifier);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public boolean isOpen(Object pageIdentifier) {
        return this.diSashModel.getSashModel().lookupPage(pageIdentifier) != null;
    }

    public void openPrevious() {
        this.setUpdating(true);
        if (this.previousStack.size() > 1) {
            this.nextStack.push(this.previousStack.pop());
            Object pageIdentifier = this.previousStack.peek();
            if (this.isOpen(pageIdentifier)) {
                this.closePage(pageIdentifier);
            }
            this.openPageWithoutStack(pageIdentifier);
        }
        this.setUpdating(false);
    }

    public void openNext() {
        this.setUpdating(true);
        if (!this.nextStack.isEmpty()) {
            Object pageIdentifier = this.nextStack.pop();
            this.previousStack.push(pageIdentifier);
            if (this.isOpen(pageIdentifier)) {
                this.closePage(pageIdentifier);
            }
            this.openPageWithoutStack(pageIdentifier);
        }
        this.setUpdating(false);
    }

    private void addToPreviousStack(Object page) {
        if (this.previousStack.isEmpty() || this.previousStack.peek() != page) {
            if (!this.nextStack.isEmpty()) {
                this.nextStack.clear();
            }
            this.previousStack.push(page);
        }
    }

    public void pageChanged(IPage newPage) {
        if (newPage != null) {
            if (!this.isUpdating() && !this.isClosingPage()) {
                Object md = newPage.getRawModel();
                if (md instanceof PageRef) {
                    Object page = ((PageRef)md).getPageIdentifier();
                    this.addToPreviousStack(page);
                }
            } else if (!this.isUpdating() && this.isClosingPage()) {
                this.setClosingPage(false);
                Object md = newPage.getRawModel();
                if (md instanceof PageRef) {
                    Object page = ((PageRef)md).getPageIdentifier();
                    if (!this.previousStack.isEmpty()) {
                        this.previousStack.pop();
                    }
                    this.addToPreviousStack(page);
                }
            }
        }
    }

    public boolean hasPreviousHistory() {
        return this.previousStack.size() > 1;
    }

    public boolean hasNextHistory() {
        return !this.nextStack.isEmpty();
    }

    public int isInHsitory(Object pageIdentifier) {
        return this.previousStack.lastIndexOf(pageIdentifier);
    }

    public void pageOpened(IPage page) {
        this.setClosingPage(false);
    }

    public void pageClosed(IPage page) {
        this.setClosingPage(true);
    }

    public void pageActivated(IPage page) {
    }

    public void pageDeactivated(IPage page) {
    }

    public void pageAboutToBeOpened(IPage page) {
    }

    public void pageAboutToBeClosed(IPage page) {
    }
}

